/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.HttpServiceWithRoutes;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RoutePathType;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerListener;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.saml.InvalidSamlRequestException;
import com.linecorp.armeria.server.saml.SamlAssertionConsumerConfig;
import com.linecorp.armeria.server.saml.SamlAssertionConsumerFunction;
import com.linecorp.armeria.server.saml.SamlEndpoint;
import com.linecorp.armeria.server.saml.SamlMetadataServiceFunction;
import com.linecorp.armeria.server.saml.SamlPortConfig;
import com.linecorp.armeria.server.saml.SamlPortConfigAutoFiller;
import com.linecorp.armeria.server.saml.SamlServiceFunction;
import com.linecorp.armeria.server.saml.SamlServiceProvider;
import com.linecorp.armeria.server.saml.SamlSingleLogoutFunction;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SamlService
implements HttpServiceWithRoutes {
    private static final HttpData DATA_INCORRECT_PATH = HttpData.ofUtf8((String)(HttpStatus.BAD_REQUEST + "\nSAML request with an incorrect path"));
    private static final HttpData DATA_AGGREGATION_FAILURE = HttpData.ofUtf8((String)(HttpStatus.BAD_REQUEST + "\nSAML request aggregation failure"));
    private static final HttpData DATA_NOT_TLS = HttpData.ofUtf8((String)(HttpStatus.BAD_REQUEST + "\nSAML request not from a TLS connection"));
    private static final HttpData DATA_NOT_CLEARTEXT = HttpData.ofUtf8((String)(HttpStatus.BAD_REQUEST + "\nSAML request not from a cleartext connection"));
    private static final Logger logger = LoggerFactory.getLogger(SamlService.class);
    private final SamlServiceProvider sp;
    private final SamlPortConfigAutoFiller portConfigHolder;
    @Nullable
    private Server server;
    private final Map<String, SamlServiceFunction> serviceMap;
    private final Set<Route> routes;

    SamlService(SamlServiceProvider sp) {
        this.sp = Objects.requireNonNull(sp, "sp");
        this.portConfigHolder = sp.portConfigAutoFiller();
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        sp.acsConfigs().forEach(cfg -> builder.put((Object)cfg.endpoint().uri().getPath(), (Object)new SamlAssertionConsumerFunction((SamlAssertionConsumerConfig)cfg, sp.entityId(), sp.idpConfigs(), sp.defaultIdpConfig(), sp.requestIdManager(), sp.ssoHandler())));
        sp.sloEndpoints().forEach(cfg -> builder.put((Object)cfg.uri().getPath(), (Object)new SamlSingleLogoutFunction((SamlEndpoint)cfg, sp.entityId(), sp.signingCredential(), sp.signatureAlgorithm(), sp.idpConfigs(), sp.defaultIdpConfig(), sp.requestIdManager(), sp.sloHandler())));
        Route route = sp.metadataRoute();
        if (route.pathType() == RoutePathType.EXACT) {
            builder.put((Object)((String)route.paths().get(0)), (Object)new SamlMetadataServiceFunction(sp.entityId(), sp.signingCredential(), sp.encryptionCredential(), sp.idpConfigs(), sp.acsConfigs(), sp.sloEndpoints()));
        }
        this.serviceMap = builder.build();
        this.routes = (Set)this.serviceMap.keySet().stream().map(path -> Route.builder().exact(path).build()).collect(ImmutableSet.toImmutableSet());
    }

    public void serviceAdded(ServiceConfig cfg) throws Exception {
        if (this.server != null) {
            if (this.server != cfg.server()) {
                throw new IllegalStateException("cannot be added to more than one server");
            }
            return;
        }
        this.server = cfg.server();
        this.server.addListener((ServerListener)this.portConfigHolder);
    }

    public Set<Route> routes() {
        return this.routes;
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        SamlServiceFunction func = this.serviceMap.get(req.path());
        if (func == null) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (HttpData)DATA_INCORRECT_PATH);
        }
        CompletionStage f = this.portConfigHolder.isDone() ? req.aggregate() : this.portConfigHolder.future().thenCompose(unused -> req.aggregate());
        return HttpResponse.from(f.handle((aggregatedReq, cause) -> {
            if (cause != null) {
                logger.warn("{} Failed to aggregate a SAML request.", (Object)ctx, cause);
                return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (HttpData)DATA_AGGREGATION_FAILURE);
            }
            SamlPortConfig portConfig = this.portConfigHolder.config();
            boolean isTls = ctx.sessionProtocol().isTls();
            if (portConfig.scheme().isTls() != isTls) {
                if (isTls) {
                    logger.warn("{} Received a SAML request via a TLS connection.", (Object)ctx);
                    return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (HttpData)DATA_NOT_CLEARTEXT);
                }
                logger.warn("{} Received a SAML request via a cleartext connection.", (Object)ctx);
                return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (HttpData)DATA_NOT_TLS);
            }
            String defaultHostname = (String)MoreObjects.firstNonNull((Object)this.sp.hostname(), (Object)ctx.config().virtualHost().defaultHostname());
            return func.serve(ctx, (AggregatedHttpRequest)aggregatedReq, defaultHostname, portConfig);
        }));
    }

    static final class SamlParameters {
        private final QueryParams params;

        SamlParameters(AggregatedHttpRequest req) {
            Objects.requireNonNull(req, "req");
            MediaType contentType = req.contentType();
            if (contentType != null && contentType.belongsTo(MediaType.FORM_DATA)) {
                String query = req.content(contentType.charset(StandardCharsets.UTF_8));
                this.params = QueryParams.fromQueryString((String)query);
            } else {
                String path = req.path();
                int queryStartIdx = path.indexOf(63);
                this.params = queryStartIdx < 0 ? QueryParams.of() : QueryParams.fromQueryString((String)path.substring(queryStartIdx + 1));
            }
        }

        String getFirstValue(String name) {
            String value = this.getFirstValueOrNull(name);
            if (value == null) {
                throw new InvalidSamlRequestException("failed to get the value of a parameter: " + name);
            }
            return value;
        }

        @Nullable
        String getFirstValueOrNull(String name) {
            Objects.requireNonNull(name, "name");
            String value = this.params.get(name);
            return Strings.emptyToNull((String)value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("parameters", (Object)this.params).toString();
        }
    }
}

