/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.saml.HttpPostBindingUtil;
import com.linecorp.armeria.server.saml.HttpRedirectBindingUtil;
import com.linecorp.armeria.server.saml.InvalidSamlRequestException;
import com.linecorp.armeria.server.saml.SamlBindingProtocol;
import com.linecorp.armeria.server.saml.SamlEndpoint;
import com.linecorp.armeria.server.saml.SamlException;
import com.linecorp.armeria.server.saml.SamlIdentityProviderConfig;
import com.linecorp.armeria.server.saml.SamlMessageUtil;
import com.linecorp.armeria.server.saml.SamlPortConfig;
import com.linecorp.armeria.server.saml.SamlRequestIdManager;
import com.linecorp.armeria.server.saml.SamlServiceFunction;
import com.linecorp.armeria.server.saml.SamlSingleLogoutHandler;
import java.util.Map;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SamlSingleLogoutFunction
implements SamlServiceFunction {
    private static final Logger logger = LoggerFactory.getLogger(SamlSingleLogoutFunction.class);
    private final SamlEndpoint endpoint;
    private final String entityId;
    private final Credential signingCredential;
    private final String signatureAlgorithm;
    private final Map<String, SamlIdentityProviderConfig> idpConfigs;
    @Nullable
    private final SamlIdentityProviderConfig defaultIdpConfig;
    private final SamlRequestIdManager requestIdManager;
    private final SamlSingleLogoutHandler sloHandler;

    SamlSingleLogoutFunction(SamlEndpoint endpoint, String entityId, Credential signingCredential, String signatureAlgorithm, Map<String, SamlIdentityProviderConfig> idpConfigs, @Nullable SamlIdentityProviderConfig defaultIdpConfig, SamlRequestIdManager requestIdManager, SamlSingleLogoutHandler sloHandler) {
        this.endpoint = endpoint;
        this.entityId = entityId;
        this.signingCredential = signingCredential;
        this.signatureAlgorithm = signatureAlgorithm;
        this.idpConfigs = idpConfigs;
        this.defaultIdpConfig = defaultIdpConfig;
        this.requestIdManager = requestIdManager;
        this.sloHandler = sloHandler;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, AggregatedHttpRequest req, String defaultHostname, SamlPortConfig portConfig) {
        try {
            SamlEndpoint sloResEndpoint;
            MessageContext messageContext = this.endpoint.bindingProtocol() == SamlBindingProtocol.HTTP_REDIRECT ? HttpRedirectBindingUtil.toSamlObject(req, "SAMLRequest", this.idpConfigs, this.defaultIdpConfig) : HttpPostBindingUtil.toSamlObject(req, "SAMLRequest");
            String endpointUri = this.endpoint.toUriString(portConfig.scheme().uriText(), defaultHostname, portConfig.port());
            LogoutRequest logoutRequest = (LogoutRequest)messageContext.getMessage();
            SamlIdentityProviderConfig idp = this.validateAndGetIdPConfig(logoutRequest, endpointUri);
            if (this.endpoint.bindingProtocol() == SamlBindingProtocol.HTTP_POST) {
                SamlMessageUtil.validateSignature(idp.signingCredential(), (SignableSAMLObject)logoutRequest);
            }
            if ((sloResEndpoint = idp.sloResEndpoint()) == null) {
                return HttpResponse.from(this.sloHandler.logoutSucceeded(ctx, req, messageContext).thenApply(unused -> HttpResponse.of((HttpStatus)HttpStatus.OK)));
            }
            LogoutResponse logoutResponse = this.createLogoutResponse(logoutRequest, "urn:oasis:names:tc:SAML:2.0:status:Success");
            try {
                HttpResponse response = this.respond(logoutResponse, sloResEndpoint);
                return HttpResponse.from(this.sloHandler.logoutSucceeded(ctx, req, messageContext).thenApply(unused -> response));
            }
            catch (SamlException e) {
                logger.warn("{} Cannot respond a logout response in response to {}", new Object[]{ctx, logoutRequest.getID(), e});
                HttpResponse response = this.fail(ctx, logoutRequest, sloResEndpoint);
                return HttpResponse.from(this.sloHandler.logoutFailed(ctx, req, e).thenApply(unused -> response));
            }
        }
        catch (SamlException e) {
            return SamlSingleLogoutFunction.fail(ctx, e);
        }
    }

    private static HttpResponse fail(ServiceRequestContext ctx, Throwable cause) {
        logger.warn("{} Cannot handle a logout request", (Object)ctx, (Object)cause);
        return HttpResponse.of((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE);
    }

    private HttpResponse fail(ServiceRequestContext ctx, LogoutRequest logoutRequest, SamlEndpoint sloResEndpoint) {
        LogoutResponse failureResponse = this.createLogoutResponse(logoutRequest, "urn:oasis:names:tc:SAML:2.0:status:Responder");
        try {
            return this.respond(failureResponse, sloResEndpoint);
        }
        catch (SamlException e) {
            return SamlSingleLogoutFunction.fail(ctx, e);
        }
    }

    private HttpResponse respond(LogoutResponse logoutResponse, SamlEndpoint sloResEndpoint) {
        if (sloResEndpoint.bindingProtocol() == SamlBindingProtocol.HTTP_REDIRECT) {
            return HttpRedirectBindingUtil.responseWithLocation(HttpRedirectBindingUtil.toRedirectionUrl((SAMLObject)logoutResponse, sloResEndpoint.toUriString(), "SAMLResponse", this.signingCredential, this.signatureAlgorithm, null));
        }
        String value = HttpPostBindingUtil.toSignedBase64((SignableSAMLObject)logoutResponse, this.signingCredential, this.signatureAlgorithm);
        HttpData body = HttpPostBindingUtil.getSsoForm(sloResEndpoint.toUriString(), "SAMLResponse", value, null);
        return HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.HTML_UTF_8, (HttpData)body);
    }

    private SamlIdentityProviderConfig validateAndGetIdPConfig(LogoutRequest logoutRequest, String endpointUri) {
        String issuer = logoutRequest.getIssuer().getValue();
        if (issuer == null) {
            throw new InvalidSamlRequestException("no issuer found from the logout request: " + logoutRequest.getID());
        }
        if (!endpointUri.equals(logoutRequest.getDestination())) {
            throw new InvalidSamlRequestException("unexpected destination: " + logoutRequest.getDestination());
        }
        SamlIdentityProviderConfig config = this.idpConfigs.get(issuer);
        if (config == null) {
            throw new InvalidSamlRequestException("unexpected identity provider: " + issuer);
        }
        return config;
    }

    private LogoutResponse createLogoutResponse(LogoutRequest logoutRequest, String statusCode) {
        StatusCode success = (StatusCode)SamlMessageUtil.build(StatusCode.DEFAULT_ELEMENT_NAME);
        success.setValue(statusCode);
        Status status = (Status)SamlMessageUtil.build(Status.DEFAULT_ELEMENT_NAME);
        status.setStatusCode(success);
        Issuer me = (Issuer)SamlMessageUtil.build(Issuer.DEFAULT_ELEMENT_NAME);
        me.setValue(this.entityId);
        LogoutResponse logoutResponse = (LogoutResponse)SamlMessageUtil.build(LogoutResponse.DEFAULT_ELEMENT_NAME);
        logoutResponse.setIssuer(me);
        logoutResponse.setID(this.requestIdManager.newId());
        logoutResponse.setIssueInstant(DateTime.now());
        logoutResponse.setStatus(status);
        logoutResponse.setInResponseTo(logoutRequest.getID());
        return logoutResponse;
    }
}

