/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.escape.Escaper;
import com.linecorp.armeria.internal.shaded.guava.html.HtmlEscapers;
import com.linecorp.armeria.server.saml.InvalidSamlRequestException;
import com.linecorp.armeria.server.saml.SamlMessageUtil;
import com.linecorp.armeria.server.saml.SamlService;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.security.credential.Credential;
import org.w3c.dom.Node;

final class HttpPostBindingUtil {
    private static final ImmutableList<String> XHTML = ImmutableList.of((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\"><head><meta http-equiv=\"content-type\" content=\"text/html;charset=utf-8\" /></head><body onload=\"document.forms[0].submit()\">", (Object)"<form method=\"post\" action=\"", (Object)"\">", (Object)"<input type=\"hidden\" name=\"", (Object)"\" value=\"", (Object)"\" />", (Object)"</form></body></html>");
    private static final Escaper HTML_ESCAPER = HtmlEscapers.htmlEscaper();

    static HttpData getSsoForm(String remoteEndpointUrl, String paramName, String paramValue, @Nullable String relayState) {
        Objects.requireNonNull(remoteEndpointUrl, "remoteEndpointUrl");
        Objects.requireNonNull(paramName, "paramName");
        Objects.requireNonNull(paramValue, "paramValue");
        StringBuilder html = new StringBuilder();
        html.append((String)XHTML.get(0)).append((String)XHTML.get(1)).append(HTML_ESCAPER.escape(remoteEndpointUrl)).append((String)XHTML.get(2)).append((String)XHTML.get(3)).append(HTML_ESCAPER.escape(paramName)).append((String)XHTML.get(4)).append(HTML_ESCAPER.escape(paramValue)).append((String)XHTML.get(5));
        if (relayState != null) {
            html.append((String)XHTML.get(3)).append("RelayState").append((String)XHTML.get(4)).append(HTML_ESCAPER.escape(relayState)).append((String)XHTML.get(5));
        }
        html.append((String)XHTML.get(6));
        return HttpData.ofUtf8((String)html.toString());
    }

    static String toSignedBase64(SignableSAMLObject signableObj, Credential signingCredential, String signatureAlgorithm) {
        SamlMessageUtil.sign(signableObj, signingCredential, signatureAlgorithm);
        String messageStr = SerializeSupport.nodeToString((Node)SamlMessageUtil.serialize((XMLObject)signableObj));
        return Base64.getEncoder().encodeToString(messageStr.getBytes(StandardCharsets.UTF_8));
    }

    static <T extends SAMLObject> MessageContext<T> toSamlObject(AggregatedHttpRequest req, String name) {
        byte[] decoded;
        SamlService.SamlParameters parameters = new SamlService.SamlParameters(req);
        try {
            decoded = Base64.getMimeDecoder().decode(parameters.getFirstValue(name));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSamlRequestException("failed to decode a base64 string of the parameter: " + name, e);
        }
        SAMLObject message = (SAMLObject)SamlMessageUtil.deserialize(decoded);
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)message);
        String relayState = parameters.getFirstValueOrNull("RelayState");
        if (relayState != null) {
            SAMLBindingContext context = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class, true);
            assert (context != null);
            context.setRelayState(relayState);
        }
        return messageContext;
    }

    private HttpPostBindingUtil() {
    }
}

