/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.saml.SamlEndpoint;
import com.linecorp.armeria.server.saml.SamlNameIdPolicy;
import java.util.Objects;
import org.opensaml.security.credential.Credential;

public final class SamlIdentityProviderConfig {
    private final String entityId;
    private final Credential signingCredential;
    private final Credential encryptionCredential;
    private final SamlEndpoint ssoEndpoint;
    @Nullable
    private final SamlEndpoint sloReqEndpoint;
    @Nullable
    private final SamlEndpoint sloResEndpoint;
    @Nullable
    private final SamlEndpoint acsEndpoint;
    private final SamlNameIdPolicy nameIdPolicy;

    SamlIdentityProviderConfig(String entityId, Credential signingCredential, Credential encryptionCredential, SamlEndpoint ssoEndpoint, @Nullable SamlEndpoint sloReqEndpoint, @Nullable SamlEndpoint sloResEndpoint, @Nullable SamlEndpoint acsEndpoint, SamlNameIdPolicy nameIdPolicy) {
        this.entityId = Objects.requireNonNull(entityId, "entityId");
        this.signingCredential = Objects.requireNonNull(signingCredential, "signingCredential");
        this.encryptionCredential = Objects.requireNonNull(encryptionCredential, "encryptionCredential");
        this.ssoEndpoint = Objects.requireNonNull(ssoEndpoint, "ssoEndpoint");
        this.sloReqEndpoint = sloReqEndpoint;
        this.sloResEndpoint = sloResEndpoint;
        this.acsEndpoint = acsEndpoint;
        this.nameIdPolicy = Objects.requireNonNull(nameIdPolicy, "nameIdPolicy");
    }

    public String entityId() {
        return this.entityId;
    }

    public Credential signingCredential() {
        return this.signingCredential;
    }

    public Credential encryptionCredential() {
        return this.encryptionCredential;
    }

    public SamlEndpoint ssoEndpoint() {
        return this.ssoEndpoint;
    }

    @Nullable
    public SamlEndpoint sloReqEndpoint() {
        return this.sloReqEndpoint;
    }

    @Nullable
    public SamlEndpoint sloResEndpoint() {
        return this.sloResEndpoint;
    }

    @Nullable
    public SamlEndpoint acsEndpoint() {
        return this.acsEndpoint;
    }

    public SamlNameIdPolicy nameIdPolicy() {
        return this.nameIdPolicy;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityId", (Object)this.entityId).add("signingCredential", (Object)this.signingCredential).add("encryptionCredential", (Object)this.encryptionCredential).add("ssoEndpoint", (Object)this.ssoEndpoint).add("sloReqEndpoint", (Object)this.sloReqEndpoint).add("sloResEndpoint", (Object)this.sloResEndpoint).add("acsEndpoint", (Object)this.acsEndpoint).add("nameIdPolicy", (Object)this.nameIdPolicy).toString();
    }
}

