/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.collect.MapMaker;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.saml.SamlAssertionConsumerConfig;
import com.linecorp.armeria.server.saml.SamlEndpoint;
import com.linecorp.armeria.server.saml.SamlException;
import com.linecorp.armeria.server.saml.SamlIdentityProviderConfig;
import com.linecorp.armeria.server.saml.SamlMessageUtil;
import com.linecorp.armeria.server.saml.SamlNameIdFormat;
import com.linecorp.armeria.server.saml.SamlPortConfig;
import com.linecorp.armeria.server.saml.SamlServiceFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class SamlMetadataServiceFunction
implements SamlServiceFunction {
    private static final Logger logger = LoggerFactory.getLogger(SamlMetadataServiceFunction.class);
    @VisibleForTesting
    static final MediaType CONTENT_TYPE_SAML_METADATA = MediaType.parse((String)"application/samlmetadata+xml");
    private static final ResponseHeaders RESPONSE_HEADERS = ResponseHeaders.of((HttpStatus)HttpStatus.OK, (CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)CONTENT_TYPE_SAML_METADATA, (CharSequence)HttpHeaderNames.CONTENT_DISPOSITION, (Object)"attachment; filename=\"saml_metadata.xml\"");
    private final String entityId;
    private final Credential signingCredential;
    private final Credential encryptionCredential;
    private final Map<String, SamlIdentityProviderConfig> idpConfigs;
    private final Collection<SamlAssertionConsumerConfig> assertionConsumerConfigs;
    private final Collection<SamlEndpoint> singleLogoutEndpoints;
    private final ConcurrentMap<String, HttpData> metadataMap = new MapMaker().makeMap();

    SamlMetadataServiceFunction(String entityId, Credential signingCredential, Credential encryptionCredential, Map<String, SamlIdentityProviderConfig> idpConfigs, Collection<SamlAssertionConsumerConfig> assertionConsumerConfigs, Collection<SamlEndpoint> singleLogoutEndpoints) {
        this.entityId = entityId;
        this.signingCredential = signingCredential;
        this.encryptionCredential = encryptionCredential;
        this.idpConfigs = idpConfigs;
        this.assertionConsumerConfigs = assertionConsumerConfigs;
        this.singleLogoutEndpoints = singleLogoutEndpoints;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, AggregatedHttpRequest req, String defaultHostname, SamlPortConfig portConfig) {
        HttpData metadata = this.metadataMap.computeIfAbsent(defaultHostname, h -> {
            try {
                Element element = SamlMessageUtil.serialize((XMLObject)this.buildMetadataEntityDescriptorElement((String)h, portConfig));
                HttpData newMetadata = HttpData.ofUtf8((String)SerializeSupport.nodeToString((Node)element));
                logger.debug("SAML service provider metadata has been prepared for: {}.", h);
                return newMetadata;
            }
            catch (Throwable cause) {
                logger.warn("{} Unexpected metadata request.", (Object)ctx, (Object)cause);
                return HttpData.empty();
            }
        });
        if (metadata != HttpData.empty()) {
            return HttpResponse.of((ResponseHeaders)RESPONSE_HEADERS, (HttpData)metadata);
        }
        return HttpResponse.of((HttpStatus)HttpStatus.NOT_FOUND);
    }

    private EntityDescriptor buildMetadataEntityDescriptorElement(String defaultHostname, SamlPortConfig portConfig) {
        EntityDescriptor entityDescriptor = (EntityDescriptor)SamlMessageUtil.build(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        entityDescriptor.setEntityID(this.entityId);
        SPSSODescriptor spSsoDescriptor = (SPSSODescriptor)SamlMessageUtil.build(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        spSsoDescriptor.setAuthnRequestsSigned(Boolean.valueOf(true));
        spSsoDescriptor.setWantAssertionsSigned(Boolean.valueOf(true));
        spSsoDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        List<String> nameIdFormats = this.idpConfigs.values().stream().map(p -> p.nameIdPolicy().format()).distinct().map(SamlNameIdFormat::urn).collect(Collectors.toList());
        spSsoDescriptor.getNameIDFormats().addAll(SamlMetadataServiceFunction.buildNameIdFormatElements(nameIdFormats));
        List sloList = spSsoDescriptor.getSingleLogoutServices();
        this.singleLogoutEndpoints.forEach(endpoint -> {
            SingleLogoutService slo = (SingleLogoutService)SamlMessageUtil.build(SingleLogoutService.DEFAULT_ELEMENT_NAME);
            slo.setBinding(endpoint.bindingProtocol().urn());
            slo.setLocation(endpoint.toUriString(portConfig.scheme().uriText(), defaultHostname, portConfig.port()));
            sloList.add(slo);
        });
        int acsIndex = 0;
        List services = spSsoDescriptor.getAssertionConsumerServices();
        for (SamlAssertionConsumerConfig acs : this.assertionConsumerConfigs) {
            services.add(SamlMetadataServiceFunction.buildAssertionConsumerServiceElement(acs, portConfig, defaultHostname, acsIndex++));
        }
        X509KeyInfoGeneratorFactory keyInfoGeneratorFactory = new X509KeyInfoGeneratorFactory();
        keyInfoGeneratorFactory.setEmitEntityCertificate(true);
        keyInfoGeneratorFactory.setEmitEntityCertificateChain(true);
        KeyInfoGenerator keyInfoGenerator = keyInfoGeneratorFactory.newInstance();
        try {
            spSsoDescriptor.getKeyDescriptors().add(SamlMetadataServiceFunction.buildKeyDescriptorElement(UsageType.SIGNING, keyInfoGenerator.generate(this.signingCredential)));
            spSsoDescriptor.getKeyDescriptors().add(SamlMetadataServiceFunction.buildKeyDescriptorElement(UsageType.ENCRYPTION, keyInfoGenerator.generate(this.encryptionCredential)));
        }
        catch (SecurityException e) {
            throw new SamlException("failed to generate KeyInfo element", e);
        }
        entityDescriptor.getRoleDescriptors().add(spSsoDescriptor);
        return entityDescriptor;
    }

    private static AssertionConsumerService buildAssertionConsumerServiceElement(SamlAssertionConsumerConfig config, SamlPortConfig portConfig, String hostname, int index) {
        AssertionConsumerService consumer = (AssertionConsumerService)SamlMessageUtil.build(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        consumer.setLocation(config.endpoint().toUriString(portConfig.scheme().uriText(), hostname, portConfig.port()));
        consumer.setBinding(config.endpoint().bindingProtocol().urn());
        consumer.setIndex(Integer.valueOf(index));
        if (config.isDefault()) {
            consumer.setIsDefault(Boolean.valueOf(true));
        }
        return consumer;
    }

    private static Collection<NameIDFormat> buildNameIdFormatElements(Collection<String> nameIds) {
        SAMLObjectBuilder builder = SamlMessageUtil.builder(NameIDFormat.DEFAULT_ELEMENT_NAME);
        ArrayList<NameIDFormat> formats = new ArrayList<NameIDFormat>();
        for (String value : nameIds) {
            NameIDFormat nameIdFormat = (NameIDFormat)builder.buildObject();
            nameIdFormat.setFormat(value);
            formats.add(nameIdFormat);
        }
        return formats;
    }

    private static KeyDescriptor buildKeyDescriptorElement(UsageType type, @Nullable KeyInfo key) {
        KeyDescriptor descriptor = (KeyDescriptor)SamlMessageUtil.build(KeyDescriptor.DEFAULT_ELEMENT_NAME);
        descriptor.setUse(type);
        descriptor.setKeyInfo(key);
        return descriptor;
    }
}

