/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.saml.SamlNameIdFormat;
import java.util.function.Predicate;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;

public final class SamlUtil {
    @Nullable
    public static NameID getNameId(Response response, SamlNameIdFormat expectedFormat) {
        return SamlUtil.getNameId(response, (NameID nameId) -> nameId.getFormat().equals(expectedFormat.urn()));
    }

    @Nullable
    public static NameID getNameId(Response response, Predicate<NameID> filter) {
        return response.getAssertions().stream().map(s -> s.getSubject().getNameID()).filter(filter).findFirst().orElse(null);
    }

    private SamlUtil() {
    }
}

