/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.saml.SamlRequestIdManager;
import io.netty.util.internal.MacAddressUtil;
import io.netty.util.internal.ThreadLocalRandom;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JwtBasedSamlRequestIdManager
implements SamlRequestIdManager {
    private static final Logger logger = LoggerFactory.getLogger(JwtBasedSamlRequestIdManager.class);
    private static final String CLAIM_NAME_UNIQUIFIER1 = "un1";
    private static final String CLAIM_NAME_UNIQUIFIER2 = "un2";
    private final String issuer;
    private final Algorithm algorithm;
    private final int validSeconds;
    private final int leewaySeconds;
    private final String un1;
    private final JWTVerifier verifier;

    JwtBasedSamlRequestIdManager(String issuer, Algorithm algorithm, int validSeconds, int leewaySeconds) {
        this.issuer = Objects.requireNonNull(issuer, "issuer");
        this.algorithm = Objects.requireNonNull(algorithm, "algorithm");
        this.validSeconds = validSeconds;
        this.leewaySeconds = leewaySeconds;
        Preconditions.checkArgument((validSeconds > 0 ? 1 : 0) != 0, (Object)("invalid valid duration: " + validSeconds + " (expected: > 0)"));
        Preconditions.checkArgument((leewaySeconds >= 0 ? 1 : 0) != 0, (Object)("invalid leeway duration:" + leewaySeconds + " (expected: >= 0)"));
        this.un1 = JwtBasedSamlRequestIdManager.getUniquifierPrefix();
        this.verifier = JWT.require((Algorithm)algorithm).withIssuer(new String[]{issuer}).acceptLeeway((long)leewaySeconds).build();
    }

    @Override
    public String newId() {
        Instant now = Instant.now();
        int un2 = ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE) & Integer.MAX_VALUE;
        return JWT.create().withIssuer(this.issuer).withIssuedAt(Date.from(now)).withExpiresAt(Date.from(now.plus((long)this.validSeconds, ChronoUnit.SECONDS))).withClaim(CLAIM_NAME_UNIQUIFIER1, this.un1).withClaim(CLAIM_NAME_UNIQUIFIER2, Integer.valueOf(un2)).sign(this.algorithm);
    }

    @Override
    public boolean validateId(String id) {
        Objects.requireNonNull(id, "id");
        try {
            this.verifier.verify(id);
            return true;
        }
        catch (Throwable cause) {
            logger.trace("JWT token validation failed", cause);
            return false;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("issuer", (Object)this.issuer).add("algorithm", (Object)this.algorithm).add("validSeconds", this.validSeconds).add("leewaySeconds", this.leewaySeconds).toString();
    }

    private static String getUniquifierPrefix() {
        byte[] r = TemporaryThreadLocals.get().byteArray(6);
        ThreadLocalRandom.current().nextBytes(r);
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(MacAddressUtil.defaultMachineId()) + encoder.encodeToString(r);
    }
}

