/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.KeyStoreCredentialResolver;

public final class KeyStoreCredentialResolverBuilder {
    @Nullable
    private final File file;
    @Nullable
    private final String resourcePath;
    @Nullable
    private final ClassLoader classLoader;
    private String type = KeyStore.getDefaultType();
    @Nullable
    private String password;
    private final Map<String, String> keyPasswords = new HashMap<String, String>();

    public KeyStoreCredentialResolverBuilder(File file) {
        this.file = Objects.requireNonNull(file, "file");
        this.resourcePath = null;
        this.classLoader = null;
    }

    public KeyStoreCredentialResolverBuilder(Path path) {
        this(Objects.requireNonNull(path, "path").toFile());
    }

    public KeyStoreCredentialResolverBuilder(ClassLoader classLoader, String resourcePath) {
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader");
        this.resourcePath = Objects.requireNonNull(resourcePath, "resourcePath");
        this.file = null;
    }

    public KeyStoreCredentialResolverBuilder type(String type) {
        this.type = Objects.requireNonNull(type, "type");
        return this;
    }

    public KeyStoreCredentialResolverBuilder password(@Nullable String password) {
        this.password = password;
        return this;
    }

    public KeyStoreCredentialResolverBuilder keyPassword(String name, String password) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(password, "password");
        Preconditions.checkArgument((!this.keyPasswords.containsKey(name) ? 1 : 0) != 0, (String)"key already exists: %s", (Object)name);
        this.keyPasswords.put(name, password);
        return this;
    }

    public KeyStoreCredentialResolverBuilder keyPasswords(Map<String, String> keyPasswords) {
        Objects.requireNonNull(keyPasswords, "keyPasswords");
        keyPasswords.forEach(this::keyPassword);
        return this;
    }

    public CredentialResolver build() throws IOException, GeneralSecurityException {
        KeyStore ks = KeyStore.getInstance(this.type);
        try (InputStream is = this.open();){
            ks.load(is, this.password != null ? this.password.toCharArray() : null);
        }
        return new KeyStoreCredentialResolver(ks, this.keyPasswords);
    }

    private InputStream open() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        ClassLoader classLoader = this.classLoader;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        assert (classLoader != null) : "classLoader";
        assert (this.resourcePath != null) : "resourcePath";
        InputStream is = classLoader.getResourceAsStream(this.resourcePath);
        if (is == null) {
            throw new FileNotFoundException("Resource not found: " + this.resourcePath);
        }
        return is;
    }
}

