/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.saml.HttpPostBindingUtil;
import com.linecorp.armeria.server.saml.HttpRedirectBindingUtil;
import com.linecorp.armeria.server.saml.InvalidSamlRequestException;
import com.linecorp.armeria.server.saml.SamlAssertionConsumerConfig;
import com.linecorp.armeria.server.saml.SamlBindingProtocol;
import com.linecorp.armeria.server.saml.SamlException;
import com.linecorp.armeria.server.saml.SamlIdentityProviderConfig;
import com.linecorp.armeria.server.saml.SamlMessageUtil;
import com.linecorp.armeria.server.saml.SamlPortConfig;
import com.linecorp.armeria.server.saml.SamlRequestIdManager;
import com.linecorp.armeria.server.saml.SamlServiceFunction;
import com.linecorp.armeria.server.saml.SamlSingleSignOnHandler;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;

final class SamlAssertionConsumerFunction
implements SamlServiceFunction {
    private static final long MILLIS_IN_MINUTE = TimeUnit.MINUTES.toMillis(1L);
    private final SamlAssertionConsumerConfig cfg;
    private final String entityId;
    private final Map<String, SamlIdentityProviderConfig> idpConfigs;
    @Nullable
    private final SamlIdentityProviderConfig defaultIdpConfig;
    private final SamlRequestIdManager requestIdManager;
    private final SamlSingleSignOnHandler ssoHandler;

    SamlAssertionConsumerFunction(SamlAssertionConsumerConfig cfg, String entityId, Map<String, SamlIdentityProviderConfig> idpConfigs, @Nullable SamlIdentityProviderConfig defaultIdpConfig, SamlRequestIdManager requestIdManager, SamlSingleSignOnHandler ssoHandler) {
        this.cfg = cfg;
        this.entityId = entityId;
        this.idpConfigs = idpConfigs;
        this.defaultIdpConfig = defaultIdpConfig;
        this.requestIdManager = requestIdManager;
        this.ssoHandler = ssoHandler;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, AggregatedHttpRequest req, String defaultHostname, SamlPortConfig portConfig) {
        try {
            MessageContext messageContext = this.cfg.endpoint().bindingProtocol() == SamlBindingProtocol.HTTP_REDIRECT ? HttpRedirectBindingUtil.toSamlObject(req, "SAMLResponse", this.idpConfigs, this.defaultIdpConfig) : HttpPostBindingUtil.toSamlObject(req, "SAMLResponse");
            String endpointUri = this.cfg.endpoint().toUriString(portConfig.scheme().uriText(), defaultHostname, portConfig.port());
            Response response = (Response)messageContext.getMessage();
            Assertion assertion = this.getValidatedAssertion(response, endpointUri);
            String sessionIndex = assertion.getAuthnStatements().stream().map(AuthnStatement::getSessionIndex).filter(Objects::nonNull).findFirst().orElse(null);
            SAMLBindingContext bindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class);
            String relayState = bindingContext != null ? bindingContext.getRelayState() : null;
            return this.ssoHandler.loginSucceeded(ctx, req, messageContext, sessionIndex, relayState);
        }
        catch (SamlException e) {
            return this.ssoHandler.loginFailed(ctx, req, null, e);
        }
    }

    private SamlIdentityProviderConfig resolveIdpConfig(Issuer issuer) {
        SamlIdentityProviderConfig config;
        String value = issuer.getValue();
        if (value != null && (config = this.idpConfigs.get(value)) != null) {
            return config;
        }
        throw new InvalidSamlRequestException("failed to find identity provider from configuration: " + issuer.getValue());
    }

    private Assertion getValidatedAssertion(Response response, String endpointUri) {
        List assertions;
        Status status = response.getStatus();
        String statusCode = status.getStatusCode().getValue();
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode)) {
            throw new InvalidSamlRequestException("response status code: " + statusCode + " (expected: " + "urn:oasis:names:tc:SAML:2.0:status:Success" + ')');
        }
        DateTime now = new DateTime();
        DateTime issueInstant = response.getIssueInstant();
        if (issueInstant == null) {
            throw new InvalidSamlRequestException("failed to get IssueInstant attribute");
        }
        if (Math.abs(now.getMillis() - issueInstant.getMillis()) > MILLIS_IN_MINUTE) {
            throw new InvalidSamlRequestException("invalid IssueInstant: " + issueInstant);
        }
        if (response.getEncryptedAssertions().isEmpty()) {
            assertions = response.getAssertions();
        } else {
            SamlIdentityProviderConfig idp;
            Issuer issuer = response.getIssuer();
            if (issuer != null) {
                idp = this.resolveIdpConfig(issuer);
            } else {
                if (this.defaultIdpConfig == null) {
                    throw new SamlException("failed to decrypt an assertion because there is no credential");
                }
                idp = this.defaultIdpConfig;
            }
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (EncryptedAssertion encryptedAssertion : response.getEncryptedAssertions()) {
                builder.add((Object)SamlAssertionConsumerFunction.decryptAssertion(encryptedAssertion, idp.encryptionCredential()));
            }
            builder.addAll((Iterable)response.getAssertions());
            assertions = builder.build();
        }
        if (assertions.isEmpty()) {
            throw new InvalidSamlRequestException("failed to get Assertion elements from the response");
        }
        for (Assertion assertion : assertions) {
            Subject subject;
            Issuer issuer = assertion.getIssuer();
            if (issuer == null || issuer.getValue() == null) {
                throw new InvalidSamlRequestException("failed to get an Issuer element from the assertion");
            }
            SamlIdentityProviderConfig idp = this.resolveIdpConfig(issuer);
            SamlMessageUtil.validateSignature(idp.signingCredential(), (SignableSAMLObject)response);
            SamlMessageUtil.validateSignature(idp.signingCredential(), (SignableSAMLObject)assertion);
            List authnStatements = assertion.getAuthnStatements();
            if (authnStatements.isEmpty() || (subject = assertion.getSubject()) == null) continue;
            List subjectConfirmations = subject.getSubjectConfirmations();
            for (SubjectConfirmation subjectConfirmation : subjectConfirmations) {
                SubjectConfirmationData data;
                if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(subjectConfirmation.getMethod()) || (data = subjectConfirmation.getSubjectConfirmationData()) == null) continue;
                if (!endpointUri.equals(data.getRecipient())) {
                    throw new InvalidSamlRequestException("recipient is not matched: " + data.getRecipient());
                }
                if (now.isAfter((ReadableInstant)data.getNotOnOrAfter())) {
                    throw new InvalidSamlRequestException("response has been expired: " + data.getNotOnOrAfter());
                }
                if (!this.requestIdManager.validateId(data.getInResponseTo())) {
                    throw new InvalidSamlRequestException("request ID is not valid: " + data.getInResponseTo());
                }
                Conditions conditions = assertion.getConditions();
                if (conditions == null) {
                    throw new InvalidSamlRequestException("no condition found from the assertion");
                }
                conditions.getAudienceRestrictions().stream().flatMap(r -> r.getAudiences().stream()).filter(audience -> this.entityId.equals(audience.getAudienceURI())).findAny().orElseThrow(() -> new InvalidSamlRequestException("no audience found from the assertion"));
                return assertion;
            }
        }
        throw new InvalidSamlRequestException("no subject found from the assertions");
    }

    private static Assertion decryptAssertion(EncryptedAssertion encryptedAssertion, Credential decryptionCredential) {
        StaticKeyInfoCredentialResolver keyInfoCredentialResolver = new StaticKeyInfoCredentialResolver(decryptionCredential);
        Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)keyInfoCredentialResolver, (EncryptedKeyResolver)new InlineEncryptedKeyResolver());
        decrypter.setRootInNewDocument(true);
        try {
            return decrypter.decrypt(encryptedAssertion);
        }
        catch (DecryptionException e) {
            throw new InvalidSamlRequestException("failed to decrypt an assertion", e);
        }
    }
}

