/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerListener;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.auth.Authorizer;
import com.linecorp.armeria.server.saml.HttpPostBindingUtil;
import com.linecorp.armeria.server.saml.HttpRedirectBindingUtil;
import com.linecorp.armeria.server.saml.SamlBindingProtocol;
import com.linecorp.armeria.server.saml.SamlEndpoint;
import com.linecorp.armeria.server.saml.SamlException;
import com.linecorp.armeria.server.saml.SamlIdentityProviderConfig;
import com.linecorp.armeria.server.saml.SamlMessageUtil;
import com.linecorp.armeria.server.saml.SamlNameIdPolicy;
import com.linecorp.armeria.server.saml.SamlPortConfig;
import com.linecorp.armeria.server.saml.SamlPortConfigAutoFiller;
import com.linecorp.armeria.server.saml.SamlRequestIdManager;
import com.linecorp.armeria.server.saml.SamlServiceProvider;
import com.linecorp.armeria.server.saml.SamlSingleSignOnHandler;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SamlDecorator
extends SimpleDecoratingHttpService {
    private static final Logger logger = LoggerFactory.getLogger(SamlDecorator.class);
    private final SamlServiceProvider sp;
    private final SamlPortConfigAutoFiller portConfigHolder;
    private final String myEntityId;
    private final Credential signingCredential;
    private final Authorizer<HttpRequest> authorizer;
    private final SamlRequestIdManager requestIdManager;
    private final SamlSingleSignOnHandler ssoHandler;
    @Nullable
    private Server server;

    SamlDecorator(SamlServiceProvider sp, HttpService delegate) {
        super(delegate);
        this.sp = sp;
        this.portConfigHolder = sp.portConfigAutoFiller();
        this.myEntityId = sp.entityId();
        this.signingCredential = sp.signingCredential();
        this.authorizer = sp.authorizer();
        this.ssoHandler = sp.ssoHandler();
        this.requestIdManager = sp.requestIdManager();
    }

    public void serviceAdded(ServiceConfig cfg) throws Exception {
        super.serviceAdded(cfg);
        if (this.server != null) {
            if (this.server != cfg.server()) {
                throw new IllegalStateException("cannot be added to more than one server");
            }
            return;
        }
        this.server = cfg.server();
        this.server.addListener((ServerListener)this.portConfigHolder);
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return HttpResponse.from(this.authorizer.authorize(ctx, (Object)req).handle((result, cause) -> {
            if (cause == null && result.booleanValue()) {
                try {
                    return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
                }
                catch (Exception e2) {
                    return (HttpResponse)Exceptions.throwUnsafely((Throwable)e2);
                }
            }
            CompletionStage f = this.portConfigHolder.isDone() ? this.sp.idpConfigSelector().select(this.sp, ctx, req) : this.portConfigHolder.future().thenCompose(unused -> this.sp.idpConfigSelector().select(this.sp, ctx, req));
            return HttpResponse.from(f.thenApply(idp -> {
                if (idp == null) {
                    throw new RuntimeException("cannot find a suitable identity provider from configurations");
                }
                String defaultHostname = (String)MoreObjects.firstNonNull((Object)this.sp.hostname(), (Object)ctx.config().virtualHost().defaultHostname());
                AuthnRequest request = this.createAuthRequest((SamlIdentityProviderConfig)idp, defaultHostname);
                MessageContext messageContext = new MessageContext();
                messageContext.setMessage((Object)request);
                return new MessageContextAndIdpConfig(messageContext, (SamlIdentityProviderConfig)idp);
            }).thenCompose(arg -> this.ssoHandler.beforeInitiatingSso(ctx, req, (MessageContext<AuthnRequest>)((MessageContextAndIdpConfig)arg).messageContext, ((MessageContextAndIdpConfig)arg).idpConfig).thenApply(unused -> arg)).thenApply(arg -> {
                SAMLBindingContext bindingContext = (SAMLBindingContext)((MessageContextAndIdpConfig)arg).messageContext.getSubcontext(SAMLBindingContext.class);
                String relayState = bindingContext != null ? bindingContext.getRelayState() : null;
                SamlEndpoint endpoint = ((MessageContextAndIdpConfig)arg).idpConfig.ssoEndpoint();
                try {
                    if (endpoint.bindingProtocol() == SamlBindingProtocol.HTTP_REDIRECT) {
                        return HttpRedirectBindingUtil.responseWithLocation(HttpRedirectBindingUtil.toRedirectionUrl((SAMLObject)((MessageContextAndIdpConfig)arg).messageContext.getMessage(), endpoint.toUriString(), "SAMLRequest", this.signingCredential, this.sp.signatureAlgorithm(), relayState));
                    }
                    String value = HttpPostBindingUtil.toSignedBase64((SignableSAMLObject)((MessageContextAndIdpConfig)arg).messageContext.getMessage(), this.signingCredential, this.sp.signatureAlgorithm());
                    HttpData body = HttpPostBindingUtil.getSsoForm(endpoint.toUriString(), "SAMLRequest", value, relayState);
                    return HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.HTML_UTF_8, (HttpData)body);
                }
                catch (SamlException e) {
                    return SamlDecorator.fail(ctx, e);
                }
            }).exceptionally(e -> SamlDecorator.fail(ctx, e)));
        }));
    }

    private static HttpResponse fail(ServiceRequestContext ctx, Throwable cause) {
        logger.trace("{} Cannot initiate SAML authentication", (Object)ctx, (Object)cause);
        return HttpResponse.of((HttpStatus)HttpStatus.UNAUTHORIZED);
    }

    private AuthnRequest createAuthRequest(SamlIdentityProviderConfig idp, String defaultHostname) {
        Objects.requireNonNull(idp, "idp");
        AuthnRequest authnRequest = (AuthnRequest)SamlMessageUtil.build(AuthnRequest.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)SamlMessageUtil.build(Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(this.myEntityId);
        authnRequest.setIssuer(issuer);
        authnRequest.setIssueInstant(DateTime.now());
        authnRequest.setDestination(idp.ssoEndpoint().toUriString());
        authnRequest.setID(this.requestIdManager.newId());
        SamlPortConfig portConfig = this.portConfigHolder.config();
        SamlEndpoint acsEndpoint = idp.acsEndpoint() != null ? idp.acsEndpoint() : this.sp.defaultAcsConfig().endpoint();
        authnRequest.setAssertionConsumerServiceURL(acsEndpoint.toUriString(portConfig.scheme().uriText(), defaultHostname, portConfig.port()));
        authnRequest.setProtocolBinding(acsEndpoint.bindingProtocol().urn());
        SamlNameIdPolicy policy = idp.nameIdPolicy();
        NameIDPolicy nameIdPolicy = (NameIDPolicy)SamlMessageUtil.build(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        nameIdPolicy.setFormat(policy.format().urn());
        nameIdPolicy.setAllowCreate(Boolean.valueOf(policy.isCreatable()));
        authnRequest.setNameIDPolicy(nameIdPolicy);
        AuthnContextClassRef passwordAuthnCtxRef = (AuthnContextClassRef)SamlMessageUtil.build(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        passwordAuthnCtxRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
        RequestedAuthnContext requestedAuthnContext = (RequestedAuthnContext)SamlMessageUtil.build(RequestedAuthnContext.DEFAULT_ELEMENT_NAME);
        requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
        requestedAuthnContext.getAuthnContextClassRefs().add(passwordAuthnCtxRef);
        authnRequest.setRequestedAuthnContext(requestedAuthnContext);
        return authnRequest;
    }

    private static final class MessageContextAndIdpConfig {
        private final MessageContext<AuthnRequest> messageContext;
        private final SamlIdentityProviderConfig idpConfig;

        private MessageContextAndIdpConfig(MessageContext<AuthnRequest> messageContext, SamlIdentityProviderConfig idpConfig) {
            this.messageContext = messageContext;
            this.idpConfig = idpConfig;
        }
    }
}

