/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.saml.SamlBindingProtocol;
import com.linecorp.armeria.server.saml.SamlPortConfig;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import javax.annotation.Nullable;

public final class SamlEndpoint {
    private final URI uri;
    private final SamlBindingProtocol bindingProtocol;
    private final String uriAsString;

    public static SamlEndpoint ofHttpRedirect(String uri) {
        Objects.requireNonNull(uri, "uri");
        try {
            return SamlEndpoint.ofHttpRedirect(new URI(uri));
        }
        catch (URISyntaxException e) {
            return (SamlEndpoint)Exceptions.throwUnsafely((Throwable)e);
        }
    }

    public static SamlEndpoint ofHttpRedirect(URI uri) {
        Objects.requireNonNull(uri, "uri");
        return new SamlEndpoint(uri, SamlBindingProtocol.HTTP_REDIRECT);
    }

    public static SamlEndpoint ofHttpPost(String uri) {
        Objects.requireNonNull(uri, "uri");
        try {
            return SamlEndpoint.ofHttpPost(new URI(uri));
        }
        catch (URISyntaxException e) {
            return (SamlEndpoint)Exceptions.throwUnsafely((Throwable)e);
        }
    }

    public static SamlEndpoint ofHttpPost(URI uri) {
        Objects.requireNonNull(uri, "uri");
        return new SamlEndpoint(uri, SamlBindingProtocol.HTTP_POST);
    }

    private SamlEndpoint(URI uri, SamlBindingProtocol bindingProtocol) {
        this.uri = uri;
        this.bindingProtocol = bindingProtocol;
        this.uriAsString = uri.toString();
    }

    public URI uri() {
        return this.uri;
    }

    public String toUriString() {
        return this.uriAsString;
    }

    String toUriString(String defaultScheme, String defaultHostname, int defaultPort) {
        Objects.requireNonNull(defaultScheme, "defaultScheme");
        Objects.requireNonNull(defaultHostname, "defaultHostname");
        SamlPortConfig.validatePort(defaultPort);
        StringBuilder sb = new StringBuilder();
        sb.append((String)MoreObjects.firstNonNull((Object)this.uri.getScheme(), (Object)defaultScheme)).append("://").append((String)MoreObjects.firstNonNull((Object)this.uri.getHost(), (Object)defaultHostname)).append(':').append(this.uri.getPort() > 0 ? this.uri.getPort() : defaultPort).append(this.uri.getPath());
        return sb.toString();
    }

    public SamlBindingProtocol bindingProtocol() {
        return this.bindingProtocol;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SamlEndpoint)) {
            return false;
        }
        SamlEndpoint that = (SamlEndpoint)o;
        return this.uri().equals(that.uri()) && this.bindingProtocol() == that.bindingProtocol();
    }

    public int hashCode() {
        return this.uri().hashCode() * 31 + this.bindingProtocol().hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uri", (Object)this.uri).add("bindingProtocol", (Object)this.bindingProtocol).toString();
    }
}

