/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.saml.SamlEndpoint;
import com.linecorp.armeria.server.saml.SamlIdentityProviderConfig;
import com.linecorp.armeria.server.saml.SamlNameIdFormat;
import com.linecorp.armeria.server.saml.SamlNameIdPolicy;
import com.linecorp.armeria.server.saml.SamlServiceProviderBuilder;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opensaml.security.credential.Credential;

public final class SamlIdentityProviderConfigBuilder {
    private static final SamlNameIdPolicy defaultNameIdPolicy = SamlNameIdPolicy.ofCreatable(SamlNameIdFormat.EMAIL);
    private final SamlServiceProviderBuilder parent;
    @Nullable
    private String entityId;
    @Nullable
    private String signingKey;
    @Nullable
    private String encryptionKey;
    @Nullable
    private SamlEndpoint ssoEndpoint;
    @Nullable
    private SamlEndpoint sloReqEndpoint;
    @Nullable
    private SamlEndpoint sloResEndpoint;
    @Nullable
    private SamlEndpoint acsEndpoint;
    private SamlNameIdPolicy nameIdPolicy = defaultNameIdPolicy;
    private boolean isDefault;

    SamlIdentityProviderConfigBuilder(SamlServiceProviderBuilder parent) {
        this.parent = parent;
    }

    public SamlIdentityProviderConfigBuilder entityId(String entityId) {
        this.entityId = Objects.requireNonNull(entityId, "entityId");
        return this;
    }

    public SamlIdentityProviderConfigBuilder signingKey(String signingKey) {
        this.signingKey = Objects.requireNonNull(signingKey, "signingKey");
        return this;
    }

    public SamlIdentityProviderConfigBuilder encryptionKey(String encryptionKey) {
        this.encryptionKey = Objects.requireNonNull(encryptionKey, "encryptionKey");
        return this;
    }

    public SamlIdentityProviderConfigBuilder ssoEndpoint(SamlEndpoint ssoEndpoint) {
        this.ssoEndpoint = Objects.requireNonNull(ssoEndpoint, "ssoEndpoint");
        return this;
    }

    public SamlIdentityProviderConfigBuilder sloReqEndpoint(SamlEndpoint sloReqEndpoint) {
        this.sloReqEndpoint = Objects.requireNonNull(sloReqEndpoint, "sloReqEndpoint");
        return this;
    }

    public SamlIdentityProviderConfigBuilder sloResEndpoint(SamlEndpoint sloResEndpoint) {
        this.sloResEndpoint = Objects.requireNonNull(sloResEndpoint, "sloResEndpoint");
        return this;
    }

    @Nullable
    SamlEndpoint acsEndpoint() {
        return this.acsEndpoint;
    }

    public SamlIdentityProviderConfigBuilder acsEndpoint(SamlEndpoint acsEndpoint) {
        this.acsEndpoint = Objects.requireNonNull(acsEndpoint, "acsEndpoint");
        return this;
    }

    public SamlIdentityProviderConfigBuilder nameIdPolicy(SamlNameIdPolicy nameIdPolicy) {
        this.nameIdPolicy = Objects.requireNonNull(nameIdPolicy, "nameIdPolicy");
        return this;
    }

    boolean isDefault() {
        return this.isDefault;
    }

    public SamlIdentityProviderConfigBuilder asDefault() {
        this.isDefault = true;
        return this;
    }

    public SamlServiceProviderBuilder and() {
        return this.parent;
    }

    SamlIdentityProviderConfig build(SamlServiceProviderBuilder.CredentialResolverAdapter credentialResolver) {
        Preconditions.checkState((this.entityId != null ? 1 : 0) != 0, (Object)"entity ID of the identity provider is not set");
        Credential signing = credentialResolver.apply((String)MoreObjects.firstNonNull((Object)this.signingKey, (Object)this.entityId));
        Credential encryption = credentialResolver.apply((String)MoreObjects.firstNonNull((Object)this.encryptionKey, (Object)this.entityId));
        return new SamlIdentityProviderConfig(this.entityId, signing, encryption, this.ssoEndpoint, this.sloReqEndpoint, this.sloResEndpoint, this.acsEndpoint, this.nameIdPolicy);
    }
}

