/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import javax.annotation.Nullable;
import org.opensaml.core.config.InitializationService;
import org.opensaml.xmlsec.config.impl.JavaCryptoValidationInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SamlInitializer {
    private static final Logger logger = LoggerFactory.getLogger(SamlInitializer.class);
    @Nullable
    private static final Throwable UNAVAILABILITY_CAUSE;

    static boolean isAvailable() {
        return SamlInitializer.unavailabilityCause() == null;
    }

    static void ensureAvailability() {
        if (!SamlInitializer.isAvailable()) {
            throw new Error("failed to initialize OpenSAML library", SamlInitializer.unavailabilityCause());
        }
    }

    @Nullable
    static Throwable unavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    private SamlInitializer() {
    }

    static {
        Throwable cause = null;
        try {
            JavaCryptoValidationInitializer javaCryptoValidationInitializer = new JavaCryptoValidationInitializer();
            javaCryptoValidationInitializer.init();
            InitializationService.initialize();
            logger.debug("OpenSAML has been initialized.");
        }
        catch (Throwable cause0) {
            cause = cause0;
        }
        finally {
            UNAVAILABILITY_CAUSE = cause;
        }
    }
}

