/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.server.saml.InvalidSamlRequestException;
import com.linecorp.armeria.server.saml.SamlException;
import com.linecorp.armeria.server.saml.SamlInitializer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.impl.SignatureBuilder;
import org.opensaml.xmlsec.signature.impl.SignatureImpl;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.opensaml.xmlsec.signature.support.Signer;
import org.w3c.dom.Element;

final class SamlMessageUtil {
    private static final XMLObjectBuilderFactory builderFactory;
    private static final KeyInfoGenerator keyInfoGenerator;
    private static final SignatureBuilder signatureBuilder;
    private static final SAMLSignatureProfileValidator signatureProfileValidator;

    static <T extends SAMLObject> SAMLObjectBuilder<T> builder(@Nullable QName key) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)builderFactory.getBuilder(key);
        assert (builder != null);
        return builder;
    }

    static <T extends SAMLObject> T build(@Nullable QName key) {
        return (T)SamlMessageUtil.builder(key).buildObject();
    }

    static Element serialize(XMLObject message) {
        Objects.requireNonNull(message, "message");
        if (message.getDOM() != null) {
            return message.getDOM();
        }
        Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller(message);
        if (marshaller == null) {
            throw new SamlException("failed to serialize a SAML object into an XML document, no serializer registered for message object: " + message.getElementQName());
        }
        try {
            return marshaller.marshall(message);
        }
        catch (MarshallingException e) {
            throw new SamlException("failed to serialize a SAML object into an XML document", e);
        }
    }

    static XMLObject deserialize(byte[] bytes) {
        Objects.requireNonNull(bytes, "bytes");
        ParserPool parserPool = XMLObjectProviderRegistrySupport.getParserPool();
        assert (parserPool != null);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            return XMLObjectSupport.unmarshallFromInputStream((ParserPool)parserPool, (InputStream)is);
        }
        catch (XMLParserException | UnmarshallingException e) {
            throw new InvalidSamlRequestException("failed to deserialize an XML document bytes into a SAML object", e);
        }
    }

    static void sign(SignableSAMLObject signableObj, Credential signingCredential, String signatureAlgorithm) {
        Objects.requireNonNull(signableObj, "signableObj");
        Objects.requireNonNull(signingCredential, "signingCredential");
        Objects.requireNonNull(signatureAlgorithm, "signatureAlgorithm");
        SignatureImpl signature = signatureBuilder.buildObject();
        signature.setSignatureAlgorithm(signatureAlgorithm);
        signature.setSigningCredential(signingCredential);
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        try {
            signature.setKeyInfo(keyInfoGenerator.generate(signingCredential));
        }
        catch (SecurityException e) {
            throw new SamlException("failed to create a key info of signing credential", e);
        }
        signableObj.setSignature((Signature)signature);
        SamlMessageUtil.serialize((XMLObject)signableObj);
        try {
            Signer.signObject((Signature)signature);
        }
        catch (SignatureException e) {
            throw new SamlException("failed to sign a SAML object", e);
        }
    }

    static void validateSignature(Credential validationCredential, SignableSAMLObject signableObj) {
        Objects.requireNonNull(validationCredential, "validationCredential");
        Objects.requireNonNull(signableObj, "signableObj");
        if (!signableObj.isSigned()) {
            return;
        }
        Signature signature = signableObj.getSignature();
        if (signature == null) {
            throw new InvalidSamlRequestException("failed to validate a signature because no signature exists");
        }
        try {
            signatureProfileValidator.validate(signature);
            SignatureValidator.validate((Signature)signature, (Credential)validationCredential);
        }
        catch (SignatureException e) {
            throw new InvalidSamlRequestException("failed to validate a signature", e);
        }
    }

    private SamlMessageUtil() {
    }

    static {
        signatureBuilder = new SignatureBuilder();
        signatureProfileValidator = new SAMLSignatureProfileValidator();
        SamlInitializer.ensureAvailability();
        builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        X509KeyInfoGeneratorFactory keyInfoGeneratorFactory = new X509KeyInfoGeneratorFactory();
        keyInfoGeneratorFactory.setEmitEntityCertificate(true);
        keyInfoGeneratorFactory.setEmitEntityCertificateChain(true);
        keyInfoGenerator = keyInfoGeneratorFactory.newInstance();
    }
}

