/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerListenerAdapter;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.saml.SamlPortConfig;
import com.linecorp.armeria.server.saml.SamlPortConfigBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

final class SamlPortConfigAutoFiller
extends ServerListenerAdapter {
    private final SamlPortConfigBuilder builder;
    private final CompletableFuture<SamlPortConfig> future = new CompletableFuture();
    private final AtomicBoolean completed = new AtomicBoolean();
    @Nullable
    private SamlPortConfig config;

    SamlPortConfigAutoFiller(SamlPortConfigBuilder builder) {
        this.builder = builder;
    }

    CompletableFuture<SamlPortConfig> future() {
        return this.future;
    }

    @Nullable
    SamlPortConfig config() {
        return this.config;
    }

    boolean isDone() {
        return this.config != null;
    }

    public void serverStarted(Server server) throws Exception {
        if (this.completed.compareAndSet(false, true)) {
            ServerPort activePort = server.activePort();
            assert (activePort != null);
            this.builder.setSchemeAndPortIfAbsent(activePort);
            assert (this.builder.scheme() != null);
            this.config = new SamlPortConfig(this.builder.scheme(), this.builder.port());
            this.future.complete(this.config);
        }
    }
}

