/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.HttpServiceWithRoutes;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.auth.Authorizer;
import com.linecorp.armeria.server.saml.SamlAssertionConsumerConfig;
import com.linecorp.armeria.server.saml.SamlDecorator;
import com.linecorp.armeria.server.saml.SamlEndpoint;
import com.linecorp.armeria.server.saml.SamlIdentityProviderConfig;
import com.linecorp.armeria.server.saml.SamlIdentityProviderConfigSelector;
import com.linecorp.armeria.server.saml.SamlPortConfigAutoFiller;
import com.linecorp.armeria.server.saml.SamlRequestIdManager;
import com.linecorp.armeria.server.saml.SamlService;
import com.linecorp.armeria.server.saml.SamlServiceProviderBuilder;
import com.linecorp.armeria.server.saml.SamlSingleLogoutHandler;
import com.linecorp.armeria.server.saml.SamlSingleSignOnHandler;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensaml.security.credential.Credential;

public final class SamlServiceProvider {
    private final Authorizer<HttpRequest> authorizer;
    private final String entityId;
    @Nullable
    private final String hostname;
    private final Credential signingCredential;
    private final Credential encryptionCredential;
    private final String signatureAlgorithm;
    private final SamlPortConfigAutoFiller portConfigAutoFiller;
    private final Route metadataRoute;
    private final Map<String, SamlIdentityProviderConfig> idpConfigs;
    @Nullable
    private final SamlIdentityProviderConfig defaultIdpConfig;
    private final SamlIdentityProviderConfigSelector idpConfigSelector;
    private final Collection<SamlAssertionConsumerConfig> acsConfigs;
    private final SamlAssertionConsumerConfig defaultAcsConfig;
    private final Collection<SamlEndpoint> sloEndpoints;
    private final SamlRequestIdManager requestIdManager;
    private final SamlSingleSignOnHandler ssoHandler;
    private final SamlSingleLogoutHandler sloHandler;

    public static SamlServiceProviderBuilder builder() {
        return new SamlServiceProviderBuilder();
    }

    SamlServiceProvider(Authorizer<HttpRequest> authorizer, String entityId, @Nullable String hostname, Credential signingCredential, Credential encryptionCredential, String signatureAlgorithm, SamlPortConfigAutoFiller portConfigAutoFiller, String metadataPath, Map<String, SamlIdentityProviderConfig> idpConfigs, @Nullable SamlIdentityProviderConfig defaultIdpConfig, SamlIdentityProviderConfigSelector idpConfigSelector, Collection<SamlAssertionConsumerConfig> acsConfigs, Collection<SamlEndpoint> sloEndpoints, SamlRequestIdManager requestIdManager, SamlSingleSignOnHandler ssoHandler, SamlSingleLogoutHandler sloHandler) {
        this.authorizer = Objects.requireNonNull(authorizer, "authorizer");
        this.entityId = Objects.requireNonNull(entityId, "entityId");
        this.hostname = hostname;
        this.signingCredential = Objects.requireNonNull(signingCredential, "signingCredential");
        this.encryptionCredential = Objects.requireNonNull(encryptionCredential, "encryptionCredential");
        this.signatureAlgorithm = Objects.requireNonNull(signatureAlgorithm, "signatureAlgorithm");
        this.portConfigAutoFiller = Objects.requireNonNull(portConfigAutoFiller, "portConfigAutoFiller");
        this.metadataRoute = Route.builder().exact(Objects.requireNonNull(metadataPath, "metadataPath")).build();
        this.idpConfigs = ImmutableMap.copyOf(Objects.requireNonNull(idpConfigs, "idpConfigs"));
        this.defaultIdpConfig = defaultIdpConfig;
        this.idpConfigSelector = Objects.requireNonNull(idpConfigSelector, "idpConfigSelector");
        this.acsConfigs = ImmutableList.copyOf(Objects.requireNonNull(acsConfigs, "acsConfigs"));
        this.sloEndpoints = ImmutableList.copyOf(Objects.requireNonNull(sloEndpoints, "sloEndpoints"));
        this.requestIdManager = Objects.requireNonNull(requestIdManager, "requestIdManager");
        this.ssoHandler = Objects.requireNonNull(ssoHandler, "ssoHandler");
        this.sloHandler = Objects.requireNonNull(sloHandler, "sloHandler");
        this.defaultAcsConfig = acsConfigs.stream().filter(SamlAssertionConsumerConfig::isDefault).findFirst().orElseThrow(() -> new IllegalArgumentException("no default assertion consumer config"));
    }

    Authorizer<HttpRequest> authorizer() {
        return this.authorizer;
    }

    String entityId() {
        return this.entityId;
    }

    @Nullable
    String hostname() {
        return this.hostname;
    }

    Credential signingCredential() {
        return this.signingCredential;
    }

    Credential encryptionCredential() {
        return this.encryptionCredential;
    }

    String signatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    SamlPortConfigAutoFiller portConfigAutoFiller() {
        return this.portConfigAutoFiller;
    }

    Route metadataRoute() {
        return this.metadataRoute;
    }

    Map<String, SamlIdentityProviderConfig> idpConfigs() {
        return this.idpConfigs;
    }

    @Nullable
    SamlIdentityProviderConfig defaultIdpConfig() {
        return this.defaultIdpConfig;
    }

    SamlIdentityProviderConfigSelector idpConfigSelector() {
        return this.idpConfigSelector;
    }

    Collection<SamlAssertionConsumerConfig> acsConfigs() {
        return this.acsConfigs;
    }

    SamlAssertionConsumerConfig defaultAcsConfig() {
        return this.defaultAcsConfig;
    }

    Collection<SamlEndpoint> sloEndpoints() {
        return this.sloEndpoints;
    }

    SamlRequestIdManager requestIdManager() {
        return this.requestIdManager;
    }

    SamlSingleSignOnHandler ssoHandler() {
        return this.ssoHandler;
    }

    SamlSingleLogoutHandler sloHandler() {
        return this.sloHandler;
    }

    public Function<? super HttpService, ? extends HttpService> newSamlDecorator() {
        return delegate -> new SamlDecorator(this, (HttpService)delegate);
    }

    public HttpServiceWithRoutes newSamlService() {
        return new SamlService(this);
    }
}

