/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.auth.Authorizer;
import com.linecorp.armeria.server.saml.HttpRedirectBindingUtil;
import com.linecorp.armeria.server.saml.SamlAssertionConsumerConfig;
import com.linecorp.armeria.server.saml.SamlAssertionConsumerConfigBuilder;
import com.linecorp.armeria.server.saml.SamlEndpoint;
import com.linecorp.armeria.server.saml.SamlIdentityProviderConfig;
import com.linecorp.armeria.server.saml.SamlIdentityProviderConfigBuilder;
import com.linecorp.armeria.server.saml.SamlIdentityProviderConfigSelector;
import com.linecorp.armeria.server.saml.SamlInitializer;
import com.linecorp.armeria.server.saml.SamlPortConfigBuilder;
import com.linecorp.armeria.server.saml.SamlRequestIdManager;
import com.linecorp.armeria.server.saml.SamlServiceProvider;
import com.linecorp.armeria.server.saml.SamlSingleLogoutHandler;
import com.linecorp.armeria.server.saml.SamlSingleSignOnHandler;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SamlServiceProviderBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SamlServiceProviderBuilder.class);
    private final List<SamlIdentityProviderConfigBuilder> idpConfigBuilders = new ArrayList<SamlIdentityProviderConfigBuilder>();
    private final List<SamlAssertionConsumerConfigBuilder> acsConfigBuilders = new ArrayList<SamlAssertionConsumerConfigBuilder>();
    private final List<SamlEndpoint> sloEndpoints = new ArrayList<SamlEndpoint>();
    private final SamlPortConfigBuilder hostConfigBuilder = new SamlPortConfigBuilder();
    @Nullable
    private String entityId;
    @Nullable
    private String hostname;
    @Nullable
    private Authorizer<HttpRequest> authorizer;
    @Nullable
    private CredentialResolverAdapter credentialResolver;
    private String signingKey = "signing";
    private String encryptionKey = "encryption";
    private String signatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private String metadataPath = "/saml/metadata";
    @Nullable
    private SamlIdentityProviderConfigSelector idpConfigSelector;
    @Nullable
    private SamlRequestIdManager requestIdManager;
    private SamlSingleSignOnHandler ssoHandler = new SamlSingleSignOnHandler(){

        @Override
        public CompletionStage<Void> beforeInitiatingSso(ServiceRequestContext ctx, HttpRequest req, MessageContext<AuthnRequest> message, SamlIdentityProviderConfig idpConfig) {
            String requestedPath = req.path();
            if (requestedPath.length() <= 80) {
                SAMLBindingContext sub = (SAMLBindingContext)message.getSubcontext(SAMLBindingContext.class, true);
                assert (sub != null) : "SAMLBindingContext";
                sub.setRelayState(requestedPath);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public HttpResponse loginSucceeded(ServiceRequestContext ctx, AggregatedHttpRequest req, MessageContext<Response> message, @Nullable String sessionIndex, @Nullable String relayState) {
            return HttpRedirectBindingUtil.responseWithLocation((String)MoreObjects.firstNonNull((Object)relayState, (Object)"/"));
        }

        @Override
        public HttpResponse loginFailed(ServiceRequestContext ctx, AggregatedHttpRequest req, @Nullable MessageContext<Response> message, Throwable cause) {
            logger.warn("{} SAML SSO failed", (Object)ctx, (Object)cause);
            return HttpRedirectBindingUtil.responseWithLocation("/error");
        }
    };
    private SamlSingleLogoutHandler sloHandler = new SamlSingleLogoutHandler(){

        @Override
        public CompletionStage<Void> logoutSucceeded(ServiceRequestContext ctx, AggregatedHttpRequest req, MessageContext<LogoutRequest> message) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletionStage<Void> logoutFailed(ServiceRequestContext ctx, AggregatedHttpRequest req, Throwable cause) {
            logger.warn("{} SAML SLO failed", (Object)ctx, (Object)cause);
            return CompletableFuture.completedFuture(null);
        }
    };

    SamlServiceProviderBuilder() {
    }

    public SamlServiceProviderBuilder authorizer(Authorizer<HttpRequest> authorizer) {
        this.authorizer = Objects.requireNonNull(authorizer, "authorizer");
        return this;
    }

    public SamlServiceProviderBuilder entityId(String entityId) {
        this.entityId = Objects.requireNonNull(entityId, "entityId");
        return this;
    }

    public SamlServiceProviderBuilder credentialResolver(CredentialResolver credentialResolver) {
        this.credentialResolver = new CredentialResolverAdapter(Objects.requireNonNull(credentialResolver, "credentialResolver"));
        return this;
    }

    public SamlServiceProviderBuilder signingKey(String signingKey) {
        this.signingKey = Objects.requireNonNull(signingKey, "signingKey");
        return this;
    }

    public SamlServiceProviderBuilder encryptionKey(String encryptionKey) {
        this.encryptionKey = Objects.requireNonNull(encryptionKey, "encryptionKey");
        return this;
    }

    public SamlServiceProviderBuilder signatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = Objects.requireNonNull(signatureAlgorithm, "signatureAlgorithm");
        return this;
    }

    public SamlServiceProviderBuilder hostname(String hostname) {
        this.hostname = Objects.requireNonNull(hostname, "hostname");
        return this;
    }

    public SamlServiceProviderBuilder scheme(SessionProtocol scheme) {
        this.hostConfigBuilder.setSchemeIfAbsent(Objects.requireNonNull(scheme, "scheme"));
        return this;
    }

    public SamlServiceProviderBuilder port(int port) {
        this.hostConfigBuilder.setPortIfAbsent(port);
        return this;
    }

    public SamlServiceProviderBuilder schemeAndPort(ServerPort serverPort) {
        this.hostConfigBuilder.setSchemeAndPortIfAbsent(Objects.requireNonNull(serverPort, "serverPort"));
        return this;
    }

    public SamlServiceProviderBuilder metadataPath(String metadataPath) {
        this.metadataPath = Objects.requireNonNull(metadataPath, "metadataPath");
        return this;
    }

    public SamlServiceProviderBuilder idpConfigSelector(SamlIdentityProviderConfigSelector idpConfigSelector) {
        this.idpConfigSelector = Objects.requireNonNull(idpConfigSelector, "idpConfigSelector");
        return this;
    }

    public SamlServiceProviderBuilder sloEndpoint(SamlEndpoint sloEndpoint) {
        this.sloEndpoints.add(Objects.requireNonNull(sloEndpoint, "sloEndpoint"));
        return this;
    }

    public SamlServiceProviderBuilder requestIdManager(SamlRequestIdManager requestIdManager) {
        this.requestIdManager = Objects.requireNonNull(requestIdManager, "requestIdManager");
        return this;
    }

    public SamlServiceProviderBuilder ssoHandler(SamlSingleSignOnHandler ssoHandler) {
        this.ssoHandler = Objects.requireNonNull(ssoHandler, "ssoHandler");
        return this;
    }

    public SamlServiceProviderBuilder sloHandler(SamlSingleLogoutHandler sloHandler) {
        this.sloHandler = Objects.requireNonNull(sloHandler, "sloHandler");
        return this;
    }

    public SamlIdentityProviderConfigBuilder idp() {
        SamlIdentityProviderConfigBuilder config = new SamlIdentityProviderConfigBuilder(this);
        this.idpConfigBuilders.add(config);
        return config;
    }

    public SamlAssertionConsumerConfigBuilder acs() {
        SamlAssertionConsumerConfigBuilder config = new SamlAssertionConsumerConfigBuilder(this);
        this.acsConfigBuilders.add(config);
        return config;
    }

    public SamlServiceProvider build() {
        List assertionConsumerConfigs;
        SamlInitializer.ensureAvailability();
        if (this.entityId == null) {
            throw new IllegalStateException("entity ID is not specified");
        }
        if (this.credentialResolver == null) {
            throw new IllegalStateException(CredentialResolver.class.getSimpleName() + " is not specified");
        }
        if (this.authorizer == null) {
            throw new IllegalStateException(Authorizer.class.getSimpleName() + " is not specified");
        }
        Credential signingCredential = this.credentialResolver.apply(this.signingKey);
        if (signingCredential == null) {
            throw new IllegalStateException("cannot resolve a " + Credential.class.getSimpleName() + " for signing: " + this.signingKey);
        }
        Credential encryptionCredential = this.credentialResolver.apply(this.encryptionKey);
        if (encryptionCredential == null) {
            throw new IllegalStateException("cannot resolve a " + Credential.class.getSimpleName() + " for encryption: " + this.encryptionKey);
        }
        SamlServiceProviderBuilder.validateSignatureAlgorithm(this.signatureAlgorithm, signingCredential);
        SamlServiceProviderBuilder.validateSignatureAlgorithm(this.signatureAlgorithm, encryptionCredential);
        ImmutableList sloEndpoints = this.sloEndpoints.isEmpty() ? ImmutableList.of((Object)SamlEndpoint.ofHttpPost("/saml/slo/post"), (Object)SamlEndpoint.ofHttpRedirect("/saml/slo/redirect")) : ImmutableList.copyOf(this.sloEndpoints);
        if (this.acsConfigBuilders.isEmpty()) {
            assertionConsumerConfigs = (List)ImmutableList.of((Object)new SamlAssertionConsumerConfigBuilder(this).endpoint(SamlEndpoint.ofHttpPost("/saml/acs/post")).asDefault(), (Object)new SamlAssertionConsumerConfigBuilder(this).endpoint(SamlEndpoint.ofHttpRedirect("/saml/acs/redirect"))).stream().map(SamlAssertionConsumerConfigBuilder::build).collect(ImmutableList.toImmutableList());
        } else {
            if (this.acsConfigBuilders.size() == 1) {
                this.acsConfigBuilders.get(0).asDefault();
            }
            assertionConsumerConfigs = (List)this.acsConfigBuilders.stream().map(SamlAssertionConsumerConfigBuilder::build).collect(ImmutableList.toImmutableList());
        }
        Set acsEndpoints = (Set)assertionConsumerConfigs.stream().map(SamlAssertionConsumerConfig::endpoint).collect(ImmutableSet.toImmutableSet());
        if (acsEndpoints.size() != assertionConsumerConfigs.size()) {
            throw new IllegalStateException("duplicated access consumer services exist");
        }
        if (this.idpConfigBuilders.isEmpty()) {
            throw new IllegalStateException("no identity provider configuration is specified");
        }
        if (this.idpConfigBuilders.size() == 1) {
            this.idpConfigBuilders.get(0).asDefault();
        }
        ImmutableMap.Builder idpConfigs = ImmutableMap.builder();
        SamlIdentityProviderConfig defaultIdpConfig = null;
        for (SamlIdentityProviderConfigBuilder builder : this.idpConfigBuilders) {
            if (builder.acsEndpoint() != null && !acsEndpoints.contains(builder.acsEndpoint())) {
                throw new IllegalStateException("unspecified access consumer service at " + builder.acsEndpoint());
            }
            SamlIdentityProviderConfig config = builder.build(this.credentialResolver);
            SamlServiceProviderBuilder.validateSignatureAlgorithm(this.signatureAlgorithm, config.signingCredential());
            SamlServiceProviderBuilder.validateSignatureAlgorithm(this.signatureAlgorithm, config.encryptionCredential());
            idpConfigs.put((Object)config.entityId(), (Object)config);
            if (!builder.isDefault()) continue;
            if (defaultIdpConfig != null) {
                throw new IllegalStateException("there has to be only one default identity provider");
            }
            defaultIdpConfig = config;
        }
        if (this.idpConfigSelector == null) {
            if (defaultIdpConfig == null) {
                throw new IllegalStateException("default identity provider does not exist");
            }
            SamlIdentityProviderConfig defaultConfig = defaultIdpConfig;
            this.idpConfigSelector = (unused1, unused2, unused3) -> CompletableFuture.completedFuture(defaultConfig);
        }
        try {
            this.requestIdManager = (SamlRequestIdManager)MoreObjects.firstNonNull((Object)this.requestIdManager, (Object)SamlRequestIdManager.ofJwt(this.entityId, this.entityId, 60, 5));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("cannot create a " + SamlRequestIdManager.class.getSimpleName(), e);
        }
        return new SamlServiceProvider(this.authorizer, this.entityId, this.hostname, signingCredential, encryptionCredential, this.signatureAlgorithm, this.hostConfigBuilder.toAutoFiller(), this.metadataPath, (Map<String, SamlIdentityProviderConfig>)idpConfigs.build(), defaultIdpConfig, this.idpConfigSelector, assertionConsumerConfigs, (Collection<SamlEndpoint>)sloEndpoints, this.requestIdManager, this.ssoHandler, this.sloHandler);
    }

    private static void validateSignatureAlgorithm(String signatureAlgorithm, Credential credential) {
        String jcaAlgorithmID = AlgorithmSupport.getAlgorithmID((String)signatureAlgorithm);
        if (jcaAlgorithmID == null) {
            throw new IllegalStateException("unsupported signature algorithm: " + signatureAlgorithm);
        }
        try {
            Signature signature = Signature.getInstance(jcaAlgorithmID);
            PrivateKey key = credential.getPrivateKey();
            if (key != null) {
                signature.initSign(key);
            } else {
                signature.initVerify(credential.getPublicKey());
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("unsupported signature algorithm: " + signatureAlgorithm, e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("failed to initialize a signature with an algorithm: " + signatureAlgorithm, e);
        }
    }

    static class CredentialResolverAdapter
    implements Function<String, Credential> {
        private final CredentialResolver resolver;

        CredentialResolverAdapter(CredentialResolver resolver) {
            this.resolver = Objects.requireNonNull(resolver, "resolver");
        }

        @Override
        @Nullable
        public Credential apply(String keyName) {
            CriteriaSet cs = new CriteriaSet();
            cs.add((Object)new EntityIdCriterion(keyName));
            try {
                return (Credential)this.resolver.resolveSingle((Object)cs);
            }
            catch (Throwable cause) {
                return (Credential)Exceptions.throwUnsafely((Throwable)cause);
            }
        }
    }
}

