/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptionValue;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.common.Scheme;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractClientFactory
implements ClientFactory {
    @Override
    public final <T> T newClient(String uri, Class<T> clientType, ClientOptionValue<?> ... options) {
        Objects.requireNonNull(uri, "uri");
        Objects.requireNonNull(options, "options");
        return this.newClient(URI.create(uri), clientType, ClientOptions.of(options));
    }

    @Override
    public final <T> T newClient(String uri, Class<T> clientType, ClientOptions options) {
        Objects.requireNonNull(uri, "uri");
        return this.newClient(URI.create(uri), clientType, options);
    }

    @Override
    public final <T> T newClient(URI uri, Class<T> clientType, ClientOptionValue<?> ... options) {
        Objects.requireNonNull(options, "options");
        return this.newClient(uri, clientType, ClientOptions.of(options));
    }

    protected final Scheme validateScheme(URI uri) {
        Objects.requireNonNull(uri, "uri");
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("URI with missing scheme: " + uri);
        }
        if (uri.getAuthority() == null) {
            throw new IllegalArgumentException("URI with missing authority: " + uri);
        }
        Optional<Scheme> parsedSchemeOpt = Scheme.tryParse(scheme);
        if (!parsedSchemeOpt.isPresent()) {
            throw new IllegalArgumentException("URI with unknown scheme: " + uri);
        }
        Scheme parsedScheme = parsedSchemeOpt.get();
        Set<Scheme> supportedSchemes = this.supportedSchemes();
        if (!supportedSchemes.contains(parsedScheme)) {
            throw new IllegalArgumentException("URI with unsupported scheme: " + uri + " (expected: " + supportedSchemes + ')');
        }
        return parsedScheme;
    }

    protected static Endpoint newEndpoint(URI uri) {
        return Endpoint.parse(uri.getAuthority());
    }
}

