/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientDecoration;
import com.linecorp.armeria.client.ClientDecorationBuilder;
import com.linecorp.armeria.client.ClientOption;
import com.linecorp.armeria.client.ClientOptionValue;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.DecoratingClientFunction;
import com.linecorp.armeria.common.DefaultHttpHeaders;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import io.netty.handler.codec.Headers;
import io.netty.util.AsciiString;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

class AbstractClientOptionsBuilder<B extends AbstractClientOptionsBuilder<?>> {
    private final Map<ClientOption<?>, ClientOptionValue<?>> options = new LinkedHashMap();
    private final ClientDecorationBuilder decoration = new ClientDecorationBuilder();
    private final HttpHeaders httpHeaders = new DefaultHttpHeaders();

    protected AbstractClientOptionsBuilder() {
    }

    protected AbstractClientOptionsBuilder(ClientOptions options) {
        Objects.requireNonNull(options, "options");
        this.options(options);
    }

    final B self() {
        return (B)this;
    }

    public B options(ClientOptions options) {
        Objects.requireNonNull(options, "options");
        options.asMap().values().forEach(this::option);
        return this.self();
    }

    public B options(ClientOptionValue<?> ... options) {
        Objects.requireNonNull(options, "options");
        for (ClientOptionValue<?> o : options) {
            this.option(o);
        }
        return this.self();
    }

    public B options(Iterable<ClientOptionValue<?>> options) {
        Objects.requireNonNull(options, "options");
        for (ClientOptionValue<?> o : options) {
            this.option(o);
        }
        return this.self();
    }

    public <T> B option(ClientOption<T> option, T value) {
        Objects.requireNonNull(option, "option");
        Objects.requireNonNull(value, "value");
        return this.option(option.newValue(value));
    }

    public <T> B option(ClientOptionValue<T> optionValue) {
        Objects.requireNonNull(optionValue, "optionValue");
        ClientOption opt = (ClientOption)((Object)optionValue.option());
        if (opt == ClientOption.DECORATION) {
            ClientDecoration d = (ClientDecoration)optionValue.value();
            d.entries().forEach(e -> this.decorator(e.requestType(), e.responseType(), e.decorator()));
        } else if (opt == ClientOption.HTTP_HEADERS) {
            HttpHeaders h = (HttpHeaders)optionValue.value();
            this.setHttpHeaders(h);
        } else {
            this.options.put(opt, optionValue);
        }
        return this.self();
    }

    public B defaultWriteTimeoutMillis(long defaultWriteTimeoutMillis) {
        return this.option(ClientOption.DEFAULT_WRITE_TIMEOUT_MILLIS, defaultWriteTimeoutMillis);
    }

    public B defaultWriteTimeout(Duration defaultWriteTimeout) {
        return this.defaultWriteTimeoutMillis(Objects.requireNonNull(defaultWriteTimeout, "defaultWriteTimeout").toMillis());
    }

    public B defaultResponseTimeoutMillis(long defaultResponseTimeoutMillis) {
        return this.option(ClientOption.DEFAULT_RESPONSE_TIMEOUT_MILLIS, defaultResponseTimeoutMillis);
    }

    public B defaultResponseTimeout(Duration defaultResponseTimeout) {
        return this.defaultResponseTimeoutMillis(Objects.requireNonNull(defaultResponseTimeout, "defaultResponseTimeout").toMillis());
    }

    public B defaultMaxResponseLength(long defaultMaxResponseLength) {
        return this.option(ClientOption.DEFAULT_MAX_RESPONSE_LENGTH, defaultMaxResponseLength);
    }

    public <T extends Client<I, O>, R extends Client<I, O>, I extends Request, O extends Response> B decorator(Class<I> requestType, Class<O> responseType, Function<T, R> decorator) {
        this.decoration.add(requestType, responseType, decorator);
        return this.self();
    }

    public <I extends Request, O extends Response> B decorator(Class<I> requestType, Class<O> responseType, DecoratingClientFunction<I, O> decorator) {
        this.decoration.add(requestType, responseType, decorator);
        return this.self();
    }

    public B addHttpHeader(AsciiString name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.httpHeaders.addObject(name, value);
        return this.self();
    }

    public B addHttpHeaders(Headers<AsciiString, String, ?> httpHeaders) {
        Objects.requireNonNull(httpHeaders, "httpHeaders");
        this.httpHeaders.add(httpHeaders);
        return this.self();
    }

    public B setHttpHeader(AsciiString name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.httpHeaders.setObject(name, value);
        return this.self();
    }

    public B setHttpHeaders(Headers<AsciiString, String, ?> httpHeaders) {
        Objects.requireNonNull(httpHeaders, "httpHeaders");
        this.httpHeaders.setAll(httpHeaders);
        return this.self();
    }

    ClientOptions buildOptions() {
        Collection<ClientOptionValue<?>> optVals = this.options.values();
        int numOpts = optVals.size();
        ClientOptionValue[] optValArray = optVals.toArray(new ClientOptionValue[numOpts + 2]);
        optValArray[numOpts] = ClientOption.DECORATION.newValue(this.decoration.build());
        optValArray[numOpts + 1] = ClientOption.HTTP_HEADERS.newValue(this.httpHeaders);
        return ClientOptions.of(optValArray);
    }
}

