/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AbstractClientOptionsBuilder;
import com.linecorp.armeria.client.ClientFactory;
import java.net.URI;
import java.util.Objects;

public final class ClientBuilder
extends AbstractClientOptionsBuilder<ClientBuilder> {
    private final URI uri;
    private ClientFactory factory = ClientFactory.DEFAULT;

    public ClientBuilder(String uri) {
        this(URI.create(Objects.requireNonNull(uri, "uri")));
    }

    public ClientBuilder(URI uri) {
        this.uri = Objects.requireNonNull(uri, "uri");
    }

    public ClientBuilder factory(ClientFactory factory) {
        this.factory = Objects.requireNonNull(factory, "factory");
        return this;
    }

    public <T> T build(Class<T> clientType) {
        Objects.requireNonNull(clientType, "clientType");
        return this.factory.newClient(this.uri, clientType, this.buildOptions());
    }
}

