/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientDecorationBuilder;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public final class ClientDecoration {
    public static final ClientDecoration NONE = new ClientDecoration(Collections.emptyList());
    private final List<Entry<?, ?>> entries;

    public static <T extends Client<I, O>, R extends Client<I, O>, I extends Request, O extends Response> ClientDecoration of(Class<I> requestType, Class<O> responseType, Function<T, R> decorator) {
        return new ClientDecorationBuilder().add(requestType, responseType, decorator).build();
    }

    ClientDecoration(List<Entry<?, ?>> entries) {
        this.entries = Collections.unmodifiableList(entries);
    }

    List<Entry<?, ?>> entries() {
        return this.entries;
    }

    public <I extends Request, O extends Response> Client<I, O> decorate(Class<I> requestType, Class<O> responseType, Client<I, O> client) {
        for (Entry<?, ?> e : this.entries) {
            if (!requestType.isAssignableFrom(e.requestType()) || !responseType.isAssignableFrom(e.responseType())) continue;
            Function<Client<?, ?>, Client<?, ?>> decorator = e.decorator();
            client = decorator.apply(client);
        }
        return client;
    }

    static final class Entry<I extends Request, O extends Response> {
        private final Class<I> requestType;
        private final Class<O> responseType;
        private final Function<Client<I, O>, Client<I, O>> decorator;

        Entry(Class<I> requestType, Class<O> responseType, Function<? extends Client<I, O>, ? extends Client<I, O>> decorator) {
            this.requestType = requestType;
            this.responseType = responseType;
            Function<Client<I, O>, Client<I, O>> castDecorator = decorator;
            this.decorator = castDecorator;
        }

        Class<I> requestType() {
            return this.requestType;
        }

        Class<O> responseType() {
            return this.responseType;
        }

        Function<Client<I, O>, Client<I, O>> decorator() {
            return this.decorator;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.requestType.equals(entry.requestType)) {
                return false;
            }
            if (!this.responseType.equals(entry.responseType)) {
                return false;
            }
            Function<Client<I, O>, Client<I, O>> decorator = this.decorator;
            return decorator == entry.decorator;
        }

        public int hashCode() {
            int result = this.requestType.hashCode();
            result = 31 * result + this.responseType.hashCode();
            result = 31 * result + System.identityHashCode(this.decorator);
            return result;
        }

        public String toString() {
            return '(' + this.requestType.getSimpleName() + ", " + this.responseType.getSimpleName() + ", " + this.decorator + ')';
        }
    }
}

