/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientDecoration;
import com.linecorp.armeria.client.DecoratingClientFunction;
import com.linecorp.armeria.client.FunctionalDecoratingClient;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.RpcResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class ClientDecorationBuilder {
    private final List<ClientDecoration.Entry<?, ?>> entries = new ArrayList();

    public <T extends Client<I, O>, R extends Client<I, O>, I extends Request, O extends Response> ClientDecorationBuilder add(Class<I> requestType, Class<O> responseType, Function<T, R> decorator) {
        Objects.requireNonNull(requestType, "requestType");
        Objects.requireNonNull(responseType, "responseType");
        Objects.requireNonNull(decorator, "decorator");
        if (!(requestType == HttpRequest.class && responseType == HttpResponse.class || requestType == RpcRequest.class && responseType == RpcResponse.class)) {
            throw new IllegalArgumentException("requestType and responseType must be HttpRequest and HttpResponse or RpcRequest and RpcResponse: " + requestType.getName() + " and " + responseType.getName());
        }
        this.entries.add(new ClientDecoration.Entry<I, O>(requestType, responseType, decorator));
        return this;
    }

    public <I extends Request, O extends Response> ClientDecorationBuilder add(Class<I> requestType, Class<O> responseType, DecoratingClientFunction<I, O> decorator) {
        Objects.requireNonNull(requestType, "requestType");
        Objects.requireNonNull(responseType, "responseType");
        Objects.requireNonNull(decorator, "decorator");
        this.entries.add(new ClientDecoration.Entry<I, O>(requestType, responseType, delegate -> new FunctionalDecoratingClient(delegate, decorator)));
        return this;
    }

    public ClientDecoration build() {
        return new ClientDecoration(this.entries);
    }
}

