/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ConvertUtils;
import com.linecorp.armeria.client.DefaultClientFactory;
import com.linecorp.armeria.client.HttpClientFactory;
import com.linecorp.armeria.client.pool.KeyedChannelPoolHandler;
import com.linecorp.armeria.client.pool.PoolKey;
import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.internal.TransportType;
import com.linecorp.armeria.internal.shaded.fastutil.objects.Object2ObjectArrayMap;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ClientFactoryBuilder {
    private static final KeyedChannelPoolHandler<PoolKey> DEFAULT_CONNECTION_POOL_LISTENER = KeyedChannelPoolHandler.noop();
    private static final Consumer<SslContextBuilder> DEFAULT_SSL_CONTEXT_CUSTOMIZER = b -> {};
    private static final Function<EventLoopGroup, DnsAddressResolverGroup> DEFAULT_ADDRESS_RESOLVER_GROUP_FACTORY = eventLoopGroup -> new DnsAddressResolverGroup(TransportType.datagramChannelType(eventLoopGroup), DnsServerAddressStreamProviders.platformDefault());
    private static final Set<ChannelOption<?>> PROHIBITED_SOCKET_OPTIONS = ImmutableSet.of(ChannelOption.ALLOW_HALF_CLOSURE, ChannelOption.AUTO_READ, ChannelOption.AUTO_CLOSE, ChannelOption.MAX_MESSAGES_PER_READ, ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, new ChannelOption[]{EpollChannelOption.EPOLL_MODE});
    private EventLoopGroup workerGroup = CommonPools.workerGroup();
    private boolean shutdownWorkerGroupOnClose;
    private final Map<ChannelOption<?>, Object> channelOptions = new Object2ObjectArrayMap();
    private Consumer<? super SslContextBuilder> sslContextCustomizer = DEFAULT_SSL_CONTEXT_CUSTOMIZER;
    private Function<? super EventLoopGroup, ? extends AddressResolverGroup<? extends InetSocketAddress>> addressResolverGroupFactory = DEFAULT_ADDRESS_RESOLVER_GROUP_FACTORY;
    private int http2InitialConnectionWindowSize = Flags.defaultHttp2InitialConnectionWindowSize();
    private int http2InitialStreamWindowSize = Flags.defaultHttp2InitialStreamWindowSize();
    private int http2MaxFrameSize = Flags.defaultHttp2MaxFrameSize();
    private long http2MaxHeaderListSize = Flags.defaultHttp2MaxHeaderListSize();
    private int http1MaxInitialLineLength = Flags.defaultHttp1MaxInitialLineLength();
    private int http1MaxHeaderSize = Flags.defaultHttp1MaxHeaderSize();
    private int http1MaxChunkSize = Flags.defaultHttp1MaxChunkSize();
    private long idleTimeoutMillis = Flags.defaultClientIdleTimeoutMillis();
    private boolean useHttp2Preface = Flags.defaultUseHttp2Preface();
    private boolean useHttp1Pipelining = Flags.defaultUseHttp1Pipelining();
    private KeyedChannelPoolHandler<? super PoolKey> connectionPoolListener = DEFAULT_CONNECTION_POOL_LISTENER;
    private MeterRegistry meterRegistry = Metrics.globalRegistry;

    public ClientFactoryBuilder() {
        this.connectTimeoutMillis(Flags.defaultConnectTimeoutMillis());
        this.channelOption(ChannelOption.SO_KEEPALIVE, true);
    }

    public ClientFactoryBuilder workerGroup(EventLoopGroup workerGroup, boolean shutdownOnClose) {
        this.workerGroup = Objects.requireNonNull(workerGroup, "workerGroup");
        this.shutdownWorkerGroupOnClose = shutdownOnClose;
        return this;
    }

    public ClientFactoryBuilder connectTimeout(Duration connectTimeout) {
        Objects.requireNonNull(connectTimeout, "connectTimeout");
        Preconditions.checkArgument(!connectTimeout.isZero() && !connectTimeout.isNegative(), "connectTimeout: %s (expected: > 0)", (Object)connectTimeout);
        return this.connectTimeoutMillis(connectTimeout.toMillis());
    }

    public ClientFactoryBuilder connectTimeoutMillis(long connectTimeoutMillis) {
        Preconditions.checkArgument(connectTimeoutMillis > 0L, "connectTimeoutMillis: %s (expected: > 0)", connectTimeoutMillis);
        return this.channelOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, ConvertUtils.safeLongToInt(connectTimeoutMillis));
    }

    @Deprecated
    public <T> ClientFactoryBuilder socketOption(ChannelOption<T> option, T value) {
        return this.channelOption(option, value);
    }

    public <T> ClientFactoryBuilder channelOption(ChannelOption<T> option, T value) {
        Objects.requireNonNull(option, "option");
        Preconditions.checkArgument(!PROHIBITED_SOCKET_OPTIONS.contains(option), "prohibited socket option: %s", option);
        this.channelOptions.put(option, Objects.requireNonNull(value, "value"));
        return this;
    }

    public ClientFactoryBuilder sslContextCustomizer(Consumer<? super SslContextBuilder> sslContextCustomizer) {
        this.sslContextCustomizer = Objects.requireNonNull(sslContextCustomizer, "sslContextCustomizer");
        return this;
    }

    public ClientFactoryBuilder addressResolverGroupFactory(Function<? super EventLoopGroup, ? extends AddressResolverGroup<? extends InetSocketAddress>> addressResolverGroupFactory) {
        this.addressResolverGroupFactory = Objects.requireNonNull(addressResolverGroupFactory, "addressResolverGroupFactory");
        return this;
    }

    public ClientFactoryBuilder http2InitialConnectionWindowSize(int http2InitialConnectionWindowSize) {
        Preconditions.checkArgument(http2InitialConnectionWindowSize >= 65535, "http2InitialConnectionWindowSize: %s (expected: >= %s and <= %s)", (Object)http2InitialConnectionWindowSize, (Object)65535, (Object)Integer.MAX_VALUE);
        this.http2InitialConnectionWindowSize = http2InitialConnectionWindowSize;
        return this;
    }

    public ClientFactoryBuilder http2InitialStreamWindowSize(int http2InitialStreamWindowSize) {
        Preconditions.checkArgument(http2InitialStreamWindowSize > 0, "http2InitialStreamWindowSize: %s (expected: > 0 and <= %s)", http2InitialStreamWindowSize, Integer.MAX_VALUE);
        this.http2InitialStreamWindowSize = http2InitialStreamWindowSize;
        return this;
    }

    public ClientFactoryBuilder http2MaxFrameSize(int http2MaxFrameSize) {
        Preconditions.checkArgument(http2MaxFrameSize >= 16384 && http2MaxFrameSize <= 0xFFFFFF, "http2MaxFramSize: %s (expected: >= %s and <= %s)", (Object)http2MaxFrameSize, (Object)16384, (Object)0xFFFFFF);
        this.http2MaxFrameSize = http2MaxFrameSize;
        return this;
    }

    public ClientFactoryBuilder http2MaxHeaderListSize(long http2MaxHeaderListSize) {
        Preconditions.checkArgument(http2MaxHeaderListSize > 0L && http2MaxHeaderListSize <= 0xFFFFFFFFL, "http2MaxHeaderListSize: %s (expected: a positive 32-bit unsigned integer)", http2MaxHeaderListSize);
        this.http2MaxHeaderListSize = http2MaxHeaderListSize;
        return this;
    }

    public ClientFactoryBuilder http1MaxInitialLineLength(int http1MaxInitialLineLength) {
        Preconditions.checkArgument(http1MaxInitialLineLength >= 0, "http1MaxInitialLineLength: %s (expected: >= 0)", http1MaxInitialLineLength);
        this.http1MaxInitialLineLength = http1MaxInitialLineLength;
        return this;
    }

    public ClientFactoryBuilder http1MaxHeaderSize(int http1MaxHeaderSize) {
        Preconditions.checkArgument(http1MaxHeaderSize >= 0, "http1MaxHeaderSize: %s (expected: >= 0)", http1MaxHeaderSize);
        this.http1MaxHeaderSize = http1MaxHeaderSize;
        return this;
    }

    public ClientFactoryBuilder http1MaxChunkSize(int http1MaxChunkSize) {
        Preconditions.checkArgument(http1MaxChunkSize >= 0, "http1MaxChunkSize: %s (expected: >= 0)", http1MaxChunkSize);
        this.http1MaxChunkSize = http1MaxChunkSize;
        return this;
    }

    public ClientFactoryBuilder idleTimeout(Duration idleTimeout) {
        Objects.requireNonNull(idleTimeout, "idleTimeout");
        Preconditions.checkArgument(!idleTimeout.isNegative(), "idleTimeout: %s (expected: >= 0)", (Object)idleTimeout);
        return this.idleTimeoutMillis(idleTimeout.toMillis());
    }

    public ClientFactoryBuilder idleTimeoutMillis(long idleTimeoutMillis) {
        Preconditions.checkArgument(idleTimeoutMillis >= 0L, "idleTimeoutMillis: %s (expected: >= 0)", idleTimeoutMillis);
        this.idleTimeoutMillis = idleTimeoutMillis;
        return this;
    }

    public ClientFactoryBuilder useHttp2Preface(boolean useHttp2Preface) {
        this.useHttp2Preface = useHttp2Preface;
        return this;
    }

    public ClientFactoryBuilder useHttp1Pipelining(boolean useHttp1Pipelining) {
        this.useHttp1Pipelining = useHttp1Pipelining;
        return this;
    }

    public ClientFactoryBuilder connectionPoolListener(KeyedChannelPoolHandler<? super PoolKey> connectionPoolListener) {
        this.connectionPoolListener = Objects.requireNonNull(connectionPoolListener, "connectionPoolListener");
        return this;
    }

    public ClientFactoryBuilder meterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
        return this;
    }

    public ClientFactory build() {
        return new DefaultClientFactory(new HttpClientFactory(this.workerGroup, this.shutdownWorkerGroupOnClose, this.channelOptions, this.sslContextCustomizer, this.addressResolverGroupFactory, this.http2InitialConnectionWindowSize, this.http2InitialStreamWindowSize, this.http2MaxFrameSize, this.http2MaxHeaderListSize, this.http1MaxInitialLineLength, this.http1MaxHeaderSize, this.http1MaxChunkSize, this.idleTimeoutMillis, this.useHttp2Preface, this.useHttp1Pipelining, this.connectionPoolListener, this.meterRegistry));
    }

    public String toString() {
        return ClientFactoryBuilder.toString(this, this.workerGroup, this.shutdownWorkerGroupOnClose, this.channelOptions, this.sslContextCustomizer, this.addressResolverGroupFactory, this.http2InitialConnectionWindowSize, this.http2InitialStreamWindowSize, this.http2MaxFrameSize, this.http2MaxHeaderListSize, this.http1MaxInitialLineLength, this.http1MaxHeaderSize, this.http1MaxChunkSize, this.idleTimeoutMillis, this.useHttp2Preface, this.useHttp1Pipelining, this.connectionPoolListener, this.meterRegistry);
    }

    static String toString(ClientFactoryBuilder self, EventLoopGroup workerGroup, boolean shutdownWorkerGroupOnClose, Map<ChannelOption<?>, Object> socketOptions, Consumer<? super SslContextBuilder> sslContextCustomizer, Function<? super EventLoopGroup, ? extends AddressResolverGroup<? extends InetSocketAddress>> addressResolverGroupFactory, int http2InitialConnectionWindowSize, int http2InitialStreamWindowSize, int http2MaxFrameSize, long http2MaxHeaderListSize, int http1MaxInitialLineLength, int http1MaxHeaderSize, int http1MaxChunkSize, long idleTimeoutMillis, boolean useHttp2Preface, boolean useHttp1Pipelining, KeyedChannelPoolHandler<? super PoolKey> connectionPoolListener, MeterRegistry meterRegistry) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(self).omitNullValues();
        helper.add("workerGroup", workerGroup + " (shutdownOnClose=" + shutdownWorkerGroupOnClose + ')').add("socketOptions", socketOptions).add("http2InitialConnectionWindowSize", http2InitialConnectionWindowSize).add("http2InitialStreamWindowSize", http2InitialStreamWindowSize).add("http2MaxFrameSize", http2MaxFrameSize).add("http2MaxHeaderListSize", http2MaxHeaderListSize).add("http1MaxInitialLineLength", http1MaxInitialLineLength).add("http1MaxHeaderSize", http1MaxHeaderSize).add("http1MaxChunkSize", http1MaxChunkSize).add("idleTimeoutMillis", idleTimeoutMillis).add("useHttp2Preface", useHttp2Preface).add("useHttp1Pipelining", useHttp1Pipelining);
        if (connectionPoolListener != DEFAULT_CONNECTION_POOL_LISTENER) {
            helper.add("connectionPoolListener", connectionPoolListener);
        }
        if (sslContextCustomizer != DEFAULT_SSL_CONTEXT_CUSTOMIZER) {
            helper.add("sslContextCustomizer", sslContextCustomizer);
        }
        if (addressResolverGroupFactory != DEFAULT_ADDRESS_RESOLVER_GROUP_FACTORY) {
            helper.add("addressResolverGroupFactory", addressResolverGroupFactory);
        }
        helper.add("meterRegistry", meterRegistry);
        return helper.toString();
    }
}

