/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientDecoration;
import com.linecorp.armeria.client.ClientOption;
import com.linecorp.armeria.client.ClientOptionValue;
import com.linecorp.armeria.common.DefaultHttpHeaders;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.util.AbstractOptionValue;
import com.linecorp.armeria.common.util.AbstractOptions;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ClientOptions
extends AbstractOptions {
    private static final Long DEFAULT_DEFAULT_WRITE_TIMEOUT_MILLIS = Duration.ofSeconds(1L).toMillis();
    private static final Collection<AsciiString> BLACKLISTED_HEADER_NAMES = Collections.unmodifiableCollection(Arrays.asList(HttpHeaderNames.CONNECTION, HttpHeaderNames.HOST, HttpHeaderNames.KEEP_ALIVE, HttpHeaderNames.METHOD, HttpHeaderNames.PATH, HttpHeaderNames.PROXY_CONNECTION, HttpHeaderNames.SCHEME, HttpHeaderNames.STATUS, HttpHeaderNames.TRANSFER_ENCODING, HttpHeaderNames.UPGRADE, HttpConversionUtil.ExtensionHeaderNames.PATH.text(), HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), HttpConversionUtil.ExtensionHeaderNames.STREAM_PROMISE_ID.text()));
    private static final ClientOptionValue<?>[] DEFAULT_OPTIONS = new ClientOptionValue[]{ClientOption.DEFAULT_WRITE_TIMEOUT_MILLIS.newValue(DEFAULT_DEFAULT_WRITE_TIMEOUT_MILLIS), ClientOption.DEFAULT_RESPONSE_TIMEOUT_MILLIS.newValue(Flags.defaultResponseTimeoutMillis()), ClientOption.DEFAULT_MAX_RESPONSE_LENGTH.newValue(Flags.defaultMaxResponseLength()), ClientOption.DECORATION.newValue(ClientDecoration.NONE), ClientOption.HTTP_HEADERS.newValue(HttpHeaders.EMPTY_HEADERS)};
    public static final ClientOptions DEFAULT = new ClientOptions(DEFAULT_OPTIONS);

    public static ClientOptions of(ClientOptionValue<?> ... options) {
        Objects.requireNonNull(options, "options");
        if (options.length == 0) {
            return DEFAULT;
        }
        return new ClientOptions(DEFAULT, options);
    }

    public static ClientOptions of(Iterable<ClientOptionValue<?>> options) {
        return new ClientOptions(DEFAULT, options);
    }

    public static ClientOptions of(ClientOptions baseOptions, ClientOptionValue<?> ... options) {
        Objects.requireNonNull(baseOptions, "baseOptions");
        Objects.requireNonNull(options, "options");
        if (options.length == 0) {
            return baseOptions;
        }
        return new ClientOptions(baseOptions, options);
    }

    public static ClientOptions of(ClientOptions baseOptions, Iterable<ClientOptionValue<?>> options) {
        Objects.requireNonNull(baseOptions, "baseOptions");
        Objects.requireNonNull(options, "options");
        return new ClientOptions(baseOptions, options);
    }

    public static ClientOptions of(ClientOptions baseOptions, ClientOptions options) {
        Objects.requireNonNull(baseOptions, "baseOptions");
        Objects.requireNonNull(options, "options");
        return new ClientOptions(baseOptions, options);
    }

    private static <T> ClientOptionValue<T> filterValue(ClientOptionValue<T> optionValue) {
        Objects.requireNonNull(optionValue, "optionValue");
        ClientOption option = (ClientOption)((Object)optionValue.option());
        Object value = optionValue.value();
        if (option == ClientOption.HTTP_HEADERS) {
            ClientOption castOption = option;
            ClientOptionValue<HttpHeaders> castOptionValue = castOption.newValue(ClientOptions.filterHttpHeaders((HttpHeaders)value));
            optionValue = castOptionValue;
        }
        return optionValue;
    }

    private static HttpHeaders filterHttpHeaders(HttpHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        for (AsciiString name : BLACKLISTED_HEADER_NAMES) {
            if (!headers.contains(name)) continue;
            throw new IllegalArgumentException("unallowed header name: " + name);
        }
        return ((HttpHeaders)new DefaultHttpHeaders().add(headers)).asImmutable();
    }

    private ClientOptions(ClientOptionValue<?> ... options) {
        super(ClientOptions::filterValue, (AbstractOptionValue[])options);
    }

    private ClientOptions(ClientOptions clientOptions, ClientOptionValue<?> ... options) {
        super(ClientOptions::filterValue, (AbstractOptions)clientOptions, (AbstractOptionValue[])options);
    }

    private ClientOptions(ClientOptions clientOptions, Iterable<ClientOptionValue<?>> options) {
        super(ClientOptions::filterValue, (AbstractOptions)clientOptions, options);
    }

    private ClientOptions(ClientOptions clientOptions, ClientOptions options) {
        super(clientOptions, options);
    }

    public <T> Optional<T> get(ClientOption<T> option) {
        return this.get0(option);
    }

    public <T> T getOrElse(ClientOption<T> option, T defaultValue) {
        return this.getOrElse0(option, defaultValue);
    }

    public Map<ClientOption<Object>, ClientOptionValue<Object>> asMap() {
        return this.asMap0();
    }

    public long defaultResponseTimeoutMillis() {
        return this.getOrElse(ClientOption.DEFAULT_RESPONSE_TIMEOUT_MILLIS, Flags.defaultResponseTimeoutMillis());
    }

    public long defaultWriteTimeoutMillis() {
        return this.getOrElse(ClientOption.DEFAULT_WRITE_TIMEOUT_MILLIS, DEFAULT_DEFAULT_WRITE_TIMEOUT_MILLIS);
    }

    public long defaultMaxResponseLength() {
        return this.getOrElse(ClientOption.DEFAULT_MAX_RESPONSE_LENGTH, Flags.defaultMaxResponseLength());
    }

    public ClientDecoration decoration() {
        return this.getOrElse(ClientOption.DECORATION, ClientDecoration.NONE);
    }

    public HttpHeaders httpHeaders() {
        return this.getOrElse(ClientOption.HTTP_HEADERS, HttpHeaders.EMPTY_HEADERS);
    }
}

