/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientBuilder;
import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptionValue;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DefaultClientRequestContext;
import com.linecorp.armeria.common.DefaultHttpHeaders;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.util.SafeCloseable;
import io.netty.util.AsciiString;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public final class Clients {
    public static <T> T newClient(String uri, Class<T> clientType, ClientOptionValue<?> ... options) {
        return Clients.newClient(ClientFactory.DEFAULT, uri, clientType, options);
    }

    public static <T> T newClient(String uri, Class<T> clientType, ClientOptions options) {
        return Clients.newClient(ClientFactory.DEFAULT, uri, clientType, options);
    }

    public static <T> T newClient(ClientFactory factory, String uri, Class<T> clientType, ClientOptionValue<?> ... options) {
        return ((ClientBuilder)new ClientBuilder(uri).factory(factory).options(options)).build(clientType);
    }

    public static <T> T newClient(ClientFactory factory, String uri, Class<T> clientType, ClientOptions options) {
        return ((ClientBuilder)new ClientBuilder(uri).factory(factory).options(options)).build(clientType);
    }

    public static <T> T newClient(URI uri, Class<T> clientType, ClientOptionValue<?> ... options) {
        return Clients.newClient(ClientFactory.DEFAULT, uri, clientType, options);
    }

    public static <T> T newClient(URI uri, Class<T> clientType, ClientOptions options) {
        return Clients.newClient(ClientFactory.DEFAULT, uri, clientType, options);
    }

    public static <T> T newClient(ClientFactory factory, URI uri, Class<T> clientType, ClientOptionValue<?> ... options) {
        return ((ClientBuilder)new ClientBuilder(uri).factory(factory).options(options)).build(clientType);
    }

    public static <T> T newClient(ClientFactory factory, URI uri, Class<T> clientType, ClientOptions options) {
        return ((ClientBuilder)new ClientBuilder(uri).factory(factory).options(options)).build(clientType);
    }

    public static <T> T newDerivedClient(T client, ClientOptionValue<?> ... additionalOptions) {
        ClientBuilderParams params = Clients.builderParams(client);
        ClientBuilder builder = Clients.newDerivedBuilder(params);
        builder.options(additionalOptions);
        return Clients.newDerivedClient(builder, params.clientType());
    }

    public static <T> T newDerivedClient(T client, Iterable<ClientOptionValue<?>> additionalOptions) {
        ClientBuilderParams params = Clients.builderParams(client);
        ClientBuilder builder = Clients.newDerivedBuilder(params);
        builder.options(additionalOptions);
        return Clients.newDerivedClient(builder, params.clientType());
    }

    public static <T> T newDerivedClient(T client, Function<? super ClientOptions, ClientOptions> configurator) {
        ClientBuilderParams params = Clients.builderParams(client);
        ClientBuilder builder = new ClientBuilder(params.uri());
        builder.factory(params.factory());
        builder.options(configurator.apply(params.options()));
        return Clients.newDerivedClient(builder, params.clientType());
    }

    private static <T> T newDerivedClient(ClientBuilder builder, Class<?> clientType) {
        return (T)builder.build(clientType);
    }

    private static ClientBuilder newDerivedBuilder(ClientBuilderParams params) {
        ClientBuilder builder = new ClientBuilder(params.uri());
        builder.factory(params.factory());
        builder.options(params.options());
        return builder;
    }

    private static ClientBuilderParams builderParams(Object client) {
        InvocationHandler handler;
        Objects.requireNonNull(client, "client");
        if (client instanceof ClientBuilderParams) {
            return (ClientBuilderParams)client;
        }
        if (Proxy.isProxyClass(client.getClass()) && (handler = Proxy.getInvocationHandler(client)) instanceof ClientBuilderParams) {
            return (ClientBuilderParams)((Object)handler);
        }
        Optional<ClientBuilderParams> params = ClientFactory.DEFAULT.clientBuilderParams(client);
        if (params.isPresent()) {
            return params.get();
        }
        throw new IllegalArgumentException("derivation not supported by: " + client.getClass().getName());
    }

    public static SafeCloseable withHttpHeader(AsciiString name, String value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        return Clients.withHttpHeaders(headers -> (HttpHeaders)headers.set(name, value));
    }

    public static SafeCloseable withHttpHeaders(Function<HttpHeaders, HttpHeaders> headerManipulator) {
        Objects.requireNonNull(headerManipulator, "headerManipulator");
        return Clients.withContextCustomizer(ctx -> {
            HttpHeaders additionalHeaders = ctx.additionalRequestHeaders();
            DefaultHttpHeaders headers = new DefaultHttpHeaders();
            if (!additionalHeaders.isEmpty()) {
                headers.set(additionalHeaders);
            }
            HttpHeaders manipulatedHeaders = (HttpHeaders)headerManipulator.apply(headers);
            ctx.setAdditionalRequestHeaders(manipulatedHeaders);
        });
    }

    public static SafeCloseable withContextCustomizer(Consumer<ClientRequestContext> contextCustomizer) {
        Objects.requireNonNull(contextCustomizer, "contextCustomizer");
        Consumer<ClientRequestContext> oldCustomizer = DefaultClientRequestContext.THREAD_LOCAL_CONTEXT_CUSTOMIZER.get();
        if (oldCustomizer != null) {
            DefaultClientRequestContext.THREAD_LOCAL_CONTEXT_CUSTOMIZER.set(oldCustomizer.andThen(contextCustomizer));
            return () -> DefaultClientRequestContext.THREAD_LOCAL_CONTEXT_CUSTOMIZER.set(oldCustomizer);
        }
        DefaultClientRequestContext.THREAD_LOCAL_CONTEXT_CUSTOMIZER.set(contextCustomizer);
        return DefaultClientRequestContext.THREAD_LOCAL_CONTEXT_CUSTOMIZER::remove;
    }

    private Clients() {
    }
}

