/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AbstractClientFactory;
import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientFactoryProvider;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClientFactory;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.util.ReleasableHolder;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultClientFactory
extends AbstractClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultClientFactory.class);
    private final HttpClientFactory httpClientFactory;
    private final Map<Scheme, ClientFactory> clientFactories;
    private final List<ClientFactory> clientFactoriesToClose;

    DefaultClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
        ArrayList<HttpClientFactory> availableClientFactories = new ArrayList<HttpClientFactory>();
        availableClientFactories.add(httpClientFactory);
        Streams.stream(ServiceLoader.load(ClientFactoryProvider.class, DefaultClientFactory.class.getClassLoader())).map(provider -> provider.newFactory(httpClientFactory)).forEach(availableClientFactories::add);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ClientFactory clientFactory : availableClientFactories) {
            clientFactory.supportedSchemes().forEach(s -> builder.put(s, f));
        }
        this.clientFactories = builder.build();
        this.clientFactoriesToClose = ImmutableList.copyOf(availableClientFactories).reverse();
    }

    @Override
    public Set<Scheme> supportedSchemes() {
        return this.clientFactories.keySet();
    }

    @Override
    public EventLoopGroup eventLoopGroup() {
        return this.httpClientFactory.eventLoopGroup();
    }

    @Override
    public Supplier<EventLoop> eventLoopSupplier() {
        return this.httpClientFactory.eventLoopSupplier();
    }

    @Override
    public ReleasableHolder<EventLoop> acquireEventLoop(Endpoint endpoint) {
        return this.httpClientFactory.acquireEventLoop(endpoint);
    }

    @Override
    public MeterRegistry meterRegistry() {
        return this.httpClientFactory.meterRegistry();
    }

    @Override
    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.httpClientFactory.setMeterRegistry(meterRegistry);
    }

    @Override
    public <T> T newClient(URI uri, Class<T> clientType, ClientOptions options) {
        Scheme scheme = this.validateScheme(uri);
        return this.clientFactories.get(scheme).newClient(uri, clientType, options);
    }

    @Override
    public <T> Optional<ClientBuilderParams> clientBuilderParams(T client) {
        for (ClientFactory factory : this.clientFactories.values()) {
            Optional<ClientBuilderParams> params = factory.clientBuilderParams(client);
            if (!params.isPresent()) continue;
            return params;
        }
        return Optional.empty();
    }

    @Override
    public void close() {
        if (this == ClientFactory.DEFAULT) {
            logger.debug("Refusing to close the default {}; must be closed via closeDefault()", (Object)ClientFactory.class.getSimpleName());
            return;
        }
        this.doClose();
    }

    void doClose() {
        this.clientFactoriesToClose.forEach(ClientFactory::close);
    }

    static {
        if (DefaultClientFactory.class.getClassLoader() == ClassLoader.getSystemClassLoader()) {
            Runtime.getRuntime().addShutdownHook(new Thread(ClientFactory::closeDefault));
        }
    }
}

