/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientOption;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.common.DefaultHttpHeaders;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.NonWrappingRequestContext;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.logging.DefaultRequestLog;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.Headers;
import io.netty.util.AsciiString;
import io.netty.util.Attribute;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class DefaultClientRequestContext
extends NonWrappingRequestContext
implements ClientRequestContext {
    static final ThreadLocal<Consumer<ClientRequestContext>> THREAD_LOCAL_CONTEXT_CUSTOMIZER = new ThreadLocal();
    private final EventLoop eventLoop;
    private final ClientOptions options;
    private final Endpoint endpoint;
    @Nullable
    private final String fragment;
    private final DefaultRequestLog log;
    private long writeTimeoutMillis;
    private long responseTimeoutMillis;
    private long maxResponseLength;
    @Nullable
    private String strVal;
    @Nullable
    private volatile HttpHeaders additionalRequestHeaders;

    public DefaultClientRequestContext(EventLoop eventLoop, MeterRegistry meterRegistry, SessionProtocol sessionProtocol, Endpoint endpoint, HttpMethod method, String path, @Nullable String query, @Nullable String fragment, ClientOptions options, Request request) {
        super(meterRegistry, sessionProtocol, method, path, query, request);
        this.eventLoop = Objects.requireNonNull(eventLoop, "eventLoop");
        this.options = Objects.requireNonNull(options, "options");
        this.endpoint = Objects.requireNonNull(endpoint, "endpoint");
        this.fragment = fragment;
        this.log = new DefaultRequestLog(this);
        this.writeTimeoutMillis = options.defaultWriteTimeoutMillis();
        this.responseTimeoutMillis = options.defaultResponseTimeoutMillis();
        this.maxResponseLength = options.defaultMaxResponseLength();
        HttpHeaders headers = options.getOrElse(ClientOption.HTTP_HEADERS, HttpHeaders.EMPTY_HEADERS);
        if (!headers.isEmpty()) {
            this.createAdditionalHeadersIfAbsent().set(headers);
        }
        this.runThreadLocalContextCustomizer();
    }

    private HttpHeaders createAdditionalHeadersIfAbsent() {
        HttpHeaders additionalRequestHeaders = this.additionalRequestHeaders;
        if (additionalRequestHeaders == null) {
            this.additionalRequestHeaders = new DefaultHttpHeaders();
            return this.additionalRequestHeaders;
        }
        return additionalRequestHeaders;
    }

    private void runThreadLocalContextCustomizer() {
        Consumer<ClientRequestContext> customizer = THREAD_LOCAL_CONTEXT_CUSTOMIZER.get();
        if (customizer != null) {
            customizer.accept(this);
        }
    }

    private DefaultClientRequestContext(DefaultClientRequestContext ctx) {
        this(ctx, (Request)ctx.request());
    }

    private DefaultClientRequestContext(DefaultClientRequestContext ctx, Request request) {
        super(ctx.meterRegistry(), ctx.sessionProtocol(), ctx.method(), ctx.path(), ctx.query(), request);
        this.eventLoop = ctx.eventLoop();
        this.options = ctx.options();
        this.endpoint = ctx.endpoint();
        this.fragment = ctx.fragment();
        this.log = new DefaultRequestLog(this);
        this.writeTimeoutMillis = ctx.writeTimeoutMillis();
        this.responseTimeoutMillis = ctx.responseTimeoutMillis();
        this.maxResponseLength = ctx.maxResponseLength();
        HttpHeaders additionalHeaders = ctx.additionalRequestHeaders();
        if (!additionalHeaders.isEmpty()) {
            this.createAdditionalHeadersIfAbsent().set(additionalHeaders);
        }
        Iterator<Attribute<?>> i = ctx.attrs();
        while (i.hasNext()) {
            this.addAttr(i.next());
        }
        this.runThreadLocalContextCustomizer();
    }

    private <T> void addAttr(Attribute<?> attribute) {
        Attribute<?> a = attribute;
        this.attr(a.key()).set(a.get());
    }

    @Override
    public ClientRequestContext newDerivedContext() {
        return new DefaultClientRequestContext(this);
    }

    @Override
    public ClientRequestContext newDerivedContext(Request request) {
        return new DefaultClientRequestContext(this, request);
    }

    @Override
    @Nullable
    protected Channel channel() {
        if (this.log.isAvailable(RequestLogAvailability.REQUEST_START)) {
            return this.log.channel();
        }
        return null;
    }

    @Override
    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    @Override
    public ClientOptions options() {
        return this.options;
    }

    @Override
    public Endpoint endpoint() {
        return this.endpoint;
    }

    @Override
    @Nullable
    public String fragment() {
        return this.fragment;
    }

    @Override
    public long writeTimeoutMillis() {
        return this.writeTimeoutMillis;
    }

    @Override
    public void setWriteTimeoutMillis(long writeTimeoutMillis) {
        if (writeTimeoutMillis < 0L) {
            throw new IllegalArgumentException("writeTimeoutMillis: " + writeTimeoutMillis + " (expected: >= 0)");
        }
        this.writeTimeoutMillis = writeTimeoutMillis;
    }

    @Override
    public void setWriteTimeout(Duration writeTimeout) {
        this.setWriteTimeoutMillis(Objects.requireNonNull(writeTimeout, "writeTimeout").toMillis());
    }

    @Override
    public long responseTimeoutMillis() {
        return this.responseTimeoutMillis;
    }

    @Override
    public void setResponseTimeoutMillis(long responseTimeoutMillis) {
        if (responseTimeoutMillis < 0L) {
            throw new IllegalArgumentException("responseTimeoutMillis: " + responseTimeoutMillis + " (expected: >= 0)");
        }
        this.responseTimeoutMillis = responseTimeoutMillis;
    }

    @Override
    public void setResponseTimeout(Duration responseTimeout) {
        this.setResponseTimeoutMillis(Objects.requireNonNull(responseTimeout, "responseTimeout").toMillis());
    }

    @Override
    public long maxResponseLength() {
        return this.maxResponseLength;
    }

    @Override
    public void setMaxResponseLength(long maxResponseLength) {
        this.maxResponseLength = maxResponseLength;
    }

    @Override
    public HttpHeaders additionalRequestHeaders() {
        if (this.additionalRequestHeaders == null) {
            return HttpHeaders.EMPTY_HEADERS;
        }
        return this.additionalRequestHeaders.asImmutable();
    }

    @Override
    public void setAdditionalRequestHeader(AsciiString name, String value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.createAdditionalHeadersIfAbsent().set(name, value);
    }

    @Override
    public void setAdditionalRequestHeaders(Headers<? extends AsciiString, ? extends String, ?> headers) {
        Objects.requireNonNull(headers, "headers");
        this.createAdditionalHeadersIfAbsent().set(headers);
    }

    @Override
    public void addAdditionalRequestHeader(AsciiString name, String value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.createAdditionalHeadersIfAbsent().add(name, value);
    }

    @Override
    public void addAdditionalRequestHeaders(Headers<? extends AsciiString, ? extends String, ?> headers) {
        Objects.requireNonNull(headers, "headers");
        this.createAdditionalHeadersIfAbsent().add(headers);
    }

    @Override
    public boolean removeAdditionalRequestHeader(AsciiString name) {
        Objects.requireNonNull(name, "name");
        HttpHeaders additionalRequestHeaders = this.additionalRequestHeaders;
        if (additionalRequestHeaders == null) {
            return false;
        }
        return additionalRequestHeaders.remove(name);
    }

    @Override
    public RequestLog log() {
        return this.log;
    }

    @Override
    public RequestLogBuilder logBuilder() {
        return this.log;
    }

    public String toString() {
        boolean hasChannel;
        String strVal = this.strVal;
        if (strVal != null) {
            return strVal;
        }
        StringBuilder buf = new StringBuilder(96);
        Channel ch = this.channel();
        boolean bl = hasChannel = ch != null;
        if (hasChannel) {
            buf.append(ch);
        }
        buf.append('[').append(this.sessionProtocol().uriText()).append("://").append(this.endpoint.authority()).append(this.path()).append('#').append((Object)this.method()).append(']');
        strVal = buf.toString();
        if (hasChannel) {
            this.strVal = strVal;
        }
        return strVal;
    }

    @Override
    public ByteBufAllocator alloc() {
        Channel channel = this.channel();
        return channel != null ? channel.alloc() : UnpooledByteBufAllocator.DEFAULT;
    }
}

