/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.UserClient;
import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.internal.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.PathAndQuery;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.channel.EventLoop;
import javax.annotation.Nullable;

final class DefaultHttpClient
extends UserClient<HttpRequest, HttpResponse>
implements HttpClient {
    DefaultHttpClient(ClientBuilderParams params, Client<HttpRequest, HttpResponse> delegate, MeterRegistry meterRegistry, SessionProtocol sessionProtocol, Endpoint endpoint) {
        super(params, delegate, meterRegistry, sessionProtocol, endpoint);
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        return this.execute(null, req);
    }

    private HttpResponse execute(@Nullable EventLoop eventLoop, HttpRequest req) {
        String concatPaths = ArmeriaHttpUtil.concatPaths(this.uri().getRawPath(), req.path());
        req.path(concatPaths);
        PathAndQuery pathAndQuery = PathAndQuery.parse(concatPaths);
        if (pathAndQuery == null) {
            req.abort();
            return HttpResponse.ofFailure(new IllegalArgumentException("invalid path: " + concatPaths));
        }
        return this.execute(eventLoop, req.method(), pathAndQuery.path(), pathAndQuery.query(), null, req, (ctx, cause) -> {
            if (ctx != null && !ctx.log().isAvailable(RequestLogAvailability.REQUEST_START)) {
                req.abort();
            }
            return HttpResponse.ofFailure(cause);
        });
    }

    @Override
    public HttpResponse execute(AggregatedHttpMessage aggregatedReq) {
        return this.execute(null, aggregatedReq);
    }

    HttpResponse execute(@Nullable EventLoop eventLoop, AggregatedHttpMessage aggregatedReq) {
        return this.execute(eventLoop, HttpRequest.of(aggregatedReq));
    }
}

