/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.endpoint.EndpointGroupRegistry;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.net.HostAndPort;
import com.linecorp.armeria.internal.shaded.guava.net.InternetDomainName;
import io.netty.util.NetUtil;
import java.net.StandardProtocolFamily;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Endpoint
implements Comparable<Endpoint> {
    private static final Comparator<Endpoint> NON_GROUP_COMPARATOR = Comparator.comparing(Endpoint::host).thenComparing(e -> e.ipAddr, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(e -> e.port);
    private static final int DEFAULT_WEIGHT = 1000;
    @Nullable
    private final String groupName;
    @Nullable
    private final String host;
    @Nullable
    private final String ipAddr;
    private final int port;
    private final int weight;
    @Nullable
    private final HostType hostType;
    @Nullable
    private String authority;

    public static Endpoint parse(String authority) {
        Objects.requireNonNull(authority, "authority");
        if (authority.startsWith("group:")) {
            return Endpoint.ofGroup(authority.substring(6));
        }
        HostAndPort parsed = HostAndPort.fromString(authority).withDefaultPort(0);
        return Endpoint.create(parsed.getHost(), parsed.getPort());
    }

    public static Endpoint ofGroup(String name) {
        Objects.requireNonNull(name, "name");
        return new Endpoint(name);
    }

    public static Endpoint of(String host, int port) {
        Endpoint.validatePort("port", port);
        return Endpoint.create(host, port);
    }

    public static Endpoint of(String host) {
        return Endpoint.create(host, 0);
    }

    @Deprecated
    public static Endpoint of(String host, int port, int weight) {
        return Endpoint.of(host, port).withWeight(weight);
    }

    private static Endpoint create(String host, int port) {
        Objects.requireNonNull(host, "host");
        if (NetUtil.isValidIpV4Address((String)host)) {
            return new Endpoint(host, host, port, 1000, HostType.IPv4_ONLY);
        }
        if (NetUtil.isValidIpV6Address((String)host)) {
            String ipV6Addr = host.charAt(0) == '[' ? host.substring(1, host.length() - 1) : host;
            return new Endpoint(ipV6Addr, ipV6Addr, port, 1000, HostType.IPv6_ONLY);
        }
        return new Endpoint(InternetDomainName.from(host).toString(), null, port, 1000, HostType.HOSTNAME_ONLY);
    }

    private Endpoint(String groupName) {
        this.groupName = groupName;
        this.host = null;
        this.ipAddr = null;
        this.port = 0;
        this.weight = 0;
        this.hostType = null;
    }

    private Endpoint(String host, @Nullable String ipAddr, int port, int weight, HostType hostType) {
        this.host = host;
        this.ipAddr = ipAddr;
        this.port = port;
        this.weight = weight;
        this.hostType = hostType;
        this.groupName = null;
        assert (ipAddr == null && hostType == HostType.HOSTNAME_ONLY || ipAddr != null && hostType != HostType.HOSTNAME_ONLY);
    }

    public boolean isGroup() {
        return this.groupName != null;
    }

    public Endpoint resolve(ClientRequestContext ctx) {
        if (this.isGroup()) {
            return EndpointGroupRegistry.selectNode(ctx, this.groupName);
        }
        return this;
    }

    public String groupName() {
        this.ensureGroup();
        return this.groupName;
    }

    public String host() {
        this.ensureSingle();
        return this.host;
    }

    @Nullable
    public String ipAddr() {
        this.ensureSingle();
        return this.ipAddr;
    }

    public boolean hasIpAddr() {
        return this.ipAddr() != null;
    }

    public boolean isIpAddrOnly() {
        this.ensureSingle();
        return this.hostType == HostType.IPv4_ONLY || this.hostType == HostType.IPv6_ONLY;
    }

    @Nullable
    public StandardProtocolFamily ipFamily() {
        this.ensureSingle();
        switch (this.hostType) {
            case HOSTNAME_AND_IPv4: 
            case IPv4_ONLY: {
                return StandardProtocolFamily.INET;
            }
            case HOSTNAME_AND_IPv6: 
            case IPv6_ONLY: {
                return StandardProtocolFamily.INET6;
            }
        }
        return null;
    }

    public int port() {
        this.ensureSingle();
        if (this.port == 0) {
            throw new IllegalStateException("port not specified");
        }
        return this.port;
    }

    public int port(int defaultValue) {
        this.ensureSingle();
        return this.port != 0 ? this.port : defaultValue;
    }

    public Endpoint withDefaultPort(int defaultPort) {
        this.ensureSingle();
        Endpoint.validatePort("defaultPort", defaultPort);
        if (this.port != 0) {
            return this;
        }
        return new Endpoint(this.host(), this.ipAddr(), defaultPort, this.weight(), this.hostType);
    }

    public Endpoint withIpAddr(@Nullable String ipAddr) {
        this.ensureSingle();
        if (ipAddr == null) {
            return this.withoutIpAddr();
        }
        if (NetUtil.isValidIpV4Address((String)ipAddr)) {
            return this.withIpAddr(ipAddr, StandardProtocolFamily.INET);
        }
        if (NetUtil.isValidIpV6Address((String)ipAddr)) {
            if (ipAddr.charAt(0) == '[') {
                ipAddr = ipAddr.substring(1, ipAddr.length() - 1);
            }
            return this.withIpAddr(ipAddr, StandardProtocolFamily.INET6);
        }
        throw new IllegalArgumentException("ipAddr: " + ipAddr + " (expected: an IP address)");
    }

    private Endpoint withIpAddr(String ipAddr, StandardProtocolFamily ipFamily) {
        if (ipAddr.equals(this.ipAddr)) {
            return this;
        }
        if (this.isIpAddrOnly()) {
            return new Endpoint(ipAddr, ipAddr, this.port, this.weight, ipFamily == StandardProtocolFamily.INET ? HostType.IPv4_ONLY : HostType.IPv6_ONLY);
        }
        return new Endpoint(this.host(), ipAddr, this.port, this.weight, ipFamily == StandardProtocolFamily.INET ? HostType.HOSTNAME_AND_IPv4 : HostType.HOSTNAME_AND_IPv6);
    }

    private Endpoint withoutIpAddr() {
        if (this.ipAddr == null) {
            return this;
        }
        if (this.isIpAddrOnly()) {
            throw new IllegalStateException("can't clear the IP address if host name is an IP address: " + this);
        }
        return new Endpoint(this.host(), null, this.port, this.weight, HostType.HOSTNAME_ONLY);
    }

    public Endpoint withWeight(int weight) {
        this.ensureSingle();
        Endpoint.validateWeight(weight);
        if (this.weight == weight) {
            return this;
        }
        return new Endpoint(this.host(), this.ipAddr(), this.port, weight, this.hostType);
    }

    public int weight() {
        this.ensureSingle();
        return this.weight;
    }

    public String authority() {
        String authority = this.authority;
        if (authority != null) {
            return authority;
        }
        authority = this.isGroup() ? "group:" + this.groupName : (this.port != 0 ? (this.hostType == HostType.IPv6_ONLY ? '[' + this.host() + "]:" + this.port : this.host() + ':' + this.port) : (this.hostType == HostType.IPv6_ONLY ? '[' + this.host() + ']' : this.host()));
        this.authority = authority;
        return this.authority;
    }

    private void ensureGroup() {
        if (!this.isGroup()) {
            throw new IllegalStateException("not a group endpoint");
        }
    }

    private void ensureSingle() {
        if (this.isGroup()) {
            throw new IllegalStateException("not a host:port endpoint");
        }
    }

    private static void validatePort(String name, int port) {
        Preconditions.checkArgument(port > 0 && port <= 65535, "%s: %s (expected: 1-65535)", (Object)name, port);
    }

    private static void validateWeight(int weight) {
        Preconditions.checkArgument(weight >= 0, "weight: %s (expected: >= 0)", weight);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint that = (Endpoint)obj;
        if (this.isGroup()) {
            if (that.isGroup()) {
                return this.groupName().equals(that.groupName());
            }
            return false;
        }
        if (that.isGroup()) {
            return false;
        }
        return this.host().equals(that.host()) && Objects.equals(this.ipAddr, that.ipAddr) && this.port == that.port;
    }

    public int hashCode() {
        return (this.authority().hashCode() * 31 + Objects.hashCode(this.ipAddr)) * 31 + this.port;
    }

    @Override
    public int compareTo(Endpoint that) {
        if (this.isGroup()) {
            if (that.isGroup()) {
                return this.groupName().compareTo(that.groupName());
            }
            return -1;
        }
        if (that.isGroup()) {
            return 1;
        }
        return NON_GROUP_COMPARATOR.compare(this, that);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this);
        helper.addValue(this.authority());
        if (!this.isGroup()) {
            if (this.hostType == HostType.HOSTNAME_AND_IPv4 || this.hostType == HostType.HOSTNAME_AND_IPv6) {
                helper.add("ipAddr", this.ipAddr);
            }
            helper.add("weight", this.weight);
        }
        return helper.toString();
    }

    private static enum HostType {
        HOSTNAME_ONLY,
        HOSTNAME_AND_IPv4,
        HOSTNAME_AND_IPv6,
        IPv4_ONLY,
        IPv6_ONLY;

    }
}

