/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.common.util.ReleasableHolder;
import com.linecorp.armeria.internal.shaded.guava.base.Joiner;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;

final class EventLoopScheduler {
    private static final long CLEANUP_INTERVAL_NANOS = Duration.ofMinutes(1L).toNanos();
    private final List<EventLoop> eventLoops;
    private final Map<String, State> map = new ConcurrentHashMap<String, State>();
    private int counter;
    private volatile long lastCleanupTimeNanos = System.nanoTime();

    EventLoopScheduler(EventLoopGroup eventLoopGroup) {
        this.eventLoops = Streams.stream(eventLoopGroup).map(EventLoop.class::cast).collect(ImmutableList.toImmutableList());
    }

    Entry acquire(Endpoint endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        State state = this.state(endpoint);
        Entry acquired = state.acquire();
        this.cleanup();
        return acquired;
    }

    List<Entry> entries(Endpoint endpoint) {
        return this.state(endpoint).entries();
    }

    private State state(Endpoint endpoint) {
        String authority = endpoint.authority();
        return this.map.computeIfAbsent(authority, e -> new State(this.eventLoops));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        if ((++this.counter & 0xFF) != 0) {
            return;
        }
        long currentTimeNanos = System.nanoTime();
        if (currentTimeNanos - this.lastCleanupTimeNanos < CLEANUP_INTERVAL_NANOS) {
            return;
        }
        Iterator<State> i = this.map.values().iterator();
        while (i.hasNext()) {
            boolean remove;
            State state;
            State state2 = state = i.next();
            synchronized (state2) {
                remove = state.allActiveRequests == 0 && currentTimeNanos - state.lastActivityTimeNanos >= CLEANUP_INTERVAL_NANOS;
            }
            if (!remove) continue;
            i.remove();
        }
        this.lastCleanupTimeNanos = System.nanoTime();
    }

    static final class Entry
    implements ReleasableHolder<EventLoop> {
        private final State parent;
        private final EventLoop eventLoop;
        private final int id;
        private int activeRequests;
        private int index;

        Entry(State parent, EventLoop eventLoop, int id) {
            this.parent = parent;
            this.eventLoop = eventLoop;
            this.id = this.index = id;
        }

        @Override
        public EventLoop get() {
            return this.eventLoop;
        }

        State parent() {
            return this.parent;
        }

        int id() {
            return this.id;
        }

        int index() {
            return this.index;
        }

        void setIndex(int index) {
            this.index = index;
        }

        int activeRequests() {
            return this.activeRequests;
        }

        @Override
        public void release() {
            this.parent.release(this);
        }

        public String toString() {
            return "(" + this.index + ", " + this.id + ", " + this.activeRequests + ')';
        }
    }

    private static final class State {
        private final List<Entry> entries;
        private final List<EventLoop> eventLoops;
        private int nextUnusedEventLoopIdx;
        private int allActiveRequests;
        private long lastActivityTimeNanos = System.nanoTime();

        State(List<EventLoop> eventLoops) {
            this.eventLoops = eventLoops;
            this.entries = new ArrayList<Entry>();
            this.nextUnusedEventLoopIdx = ThreadLocalRandom.current().nextInt(eventLoops.size());
            this.addUnusedEventLoop();
        }

        List<Entry> entries() {
            return this.entries;
        }

        synchronized Entry acquire() {
            Entry e = this.entries.get(0);
            if (e.activeRequests() > 0 && this.addUnusedEventLoop()) {
                e = this.entries.get(0);
                assert (e.activeRequests() == 0);
            }
            assert (e.index() == 0);
            e.activeRequests++;
            ++this.allActiveRequests;
            this.bubbleDown(0);
            return e;
        }

        private boolean addUnusedEventLoop() {
            if (this.entries.size() < this.eventLoops.size()) {
                this.push(new Entry(this, this.eventLoops.get(this.nextUnusedEventLoopIdx), this.entries.size()));
                this.nextUnusedEventLoopIdx = (this.nextUnusedEventLoopIdx + 1) % this.eventLoops.size();
                return true;
            }
            return false;
        }

        synchronized void release(Entry e) {
            assert (e.parent() == this);
            e.activeRequests--;
            this.bubbleUp(e.index());
            if (--this.allActiveRequests == 0) {
                this.lastActivityTimeNanos = System.nanoTime();
            }
        }

        private void push(Entry e) {
            this.entries.add(e);
            this.bubbleUp(this.entries.size() - 1);
        }

        private void bubbleDown(int i) {
            int best = i;
            while (true) {
                int oldBest = best;
                int left = State.left(best);
                if (left >= this.entries.size()) break;
                int right = State.right(best);
                if (this.isBetter(left, best)) {
                    best = right < this.entries.size() ? (this.isBetter(right, left) ? right : left) : left;
                } else {
                    if (right >= this.entries.size() || !this.isBetter(right, best)) break;
                    best = right;
                }
                this.swap(best, oldBest);
            }
        }

        private void bubbleUp(int i) {
            int parent;
            while (i > 0 && !this.isBetter(parent = State.parent(i), i)) {
                this.swap(parent, i);
                i = parent;
            }
        }

        private boolean isBetter(int a, int b) {
            Entry entryA = this.entries.get(a);
            Entry entryB = this.entries.get(b);
            if (entryA.activeRequests() < entryB.activeRequests()) {
                return true;
            }
            if (entryA.activeRequests() > entryB.activeRequests()) {
                return false;
            }
            return entryA.id() < entryB.id();
        }

        private static int parent(int i) {
            return (i - 1) / 2;
        }

        private static int left(int i) {
            return 2 * i + 1;
        }

        private static int right(int i) {
            return 2 * i + 2;
        }

        private void swap(int i, int j) {
            Entry entryI = this.entries.get(i);
            Entry entryJ = this.entries.get(j);
            this.entries.set(i, entryJ);
            this.entries.set(j, entryI);
            entryJ.setIndex(i);
            entryI.setIndex(j);
        }

        public String toString() {
            return '[' + Joiner.on(", ").join(this.entries) + ']';
        }
    }
}

