/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.Http2ResponseDecoder;
import com.linecorp.armeria.client.HttpClientFactory;
import com.linecorp.armeria.client.HttpSession;
import com.linecorp.armeria.internal.AbstractHttp2ConnectionHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Settings;

final class Http2ClientConnectionHandler
extends AbstractHttp2ConnectionHandler {
    private final HttpClientFactory clientFactory;
    private final Http2ResponseDecoder responseDecoder;

    Http2ClientConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, Channel channel, HttpClientFactory clientFactory) {
        super(decoder, encoder, initialSettings);
        this.clientFactory = clientFactory;
        this.responseDecoder = new Http2ResponseDecoder(channel, this.encoder());
        this.connection().addListener((Http2Connection.Listener)this.responseDecoder);
        this.decoder().frameListener((Http2FrameListener)this.responseDecoder);
        long timeout = clientFactory.idleTimeoutMillis();
        if (timeout > 0L) {
            this.gracefulShutdownTimeoutMillis(timeout);
        } else {
            this.gracefulShutdownTimeoutMillis(-1L);
        }
    }

    Http2ResponseDecoder responseDecoder() {
        return this.responseDecoder;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        ctx.flush();
    }

    @Override
    protected void onCloseRequest(ChannelHandlerContext ctx) throws Exception {
        HttpSession.get(ctx.channel()).deactivate();
    }

    @Override
    protected boolean needsImmediateDisconnection() {
        return this.clientFactory.isClosing() || this.responseDecoder.goAwayHandler().receivedErrorGoAway();
    }
}

