/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.DecodedHttpResponse;
import com.linecorp.armeria.client.HttpResponseDecoder;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.ContentTooLargeException;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.internal.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.Http2GoAwayHandler;
import com.linecorp.armeria.unsafe.ByteBufHttpData;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Http2ResponseDecoder
extends HttpResponseDecoder
implements Http2Connection.Listener,
Http2FrameListener {
    private static final Logger logger = LoggerFactory.getLogger(Http2ResponseDecoder.class);
    private final Http2Connection conn;
    private final Http2ConnectionEncoder encoder;
    private final Http2GoAwayHandler goAwayHandler;

    Http2ResponseDecoder(Channel channel, Http2ConnectionEncoder encoder) {
        super(channel);
        this.conn = encoder.connection();
        this.encoder = encoder;
        this.goAwayHandler = new Http2GoAwayHandler();
    }

    @Override
    HttpResponseDecoder.HttpResponseWrapper addResponse(int id, @Nullable HttpRequest req, DecodedHttpResponse res, RequestLogBuilder logBuilder, long responseTimeoutMillis, long maxContentLength) {
        HttpResponseDecoder.HttpResponseWrapper resWrapper = super.addResponse(id, req, res, logBuilder, responseTimeoutMillis, maxContentLength);
        resWrapper.completionFuture().whenCompleteAsync((unused, cause) -> {
            resWrapper.onSubscriptionCancelled();
            if (cause != null) {
                ChannelHandlerContext ctx;
                this.removeResponse(id);
                int streamId = Http2ResponseDecoder.idToStreamId(id);
                int lastStreamId = this.conn.local().lastStreamKnownByPeer();
                if ((lastStreamId < 0 || streamId <= lastStreamId) && (ctx = this.channel().pipeline().lastContext()) != null) {
                    this.encoder.writeRstStream(ctx, streamId, Http2Error.CANCEL.code(), ctx.newPromise());
                    ctx.flush();
                }
            }
        }, (Executor)this.channel().eventLoop());
        return resWrapper;
    }

    Http2GoAwayHandler goAwayHandler() {
        return this.goAwayHandler;
    }

    public void onStreamAdded(Http2Stream stream) {
    }

    public void onStreamActive(Http2Stream stream) {
    }

    public void onStreamHalfClosed(Http2Stream stream) {
    }

    public void onStreamClosed(Http2Stream stream) {
        this.goAwayHandler.onStreamClosed(this.channel(), stream);
        HttpResponseDecoder.HttpResponseWrapper res = this.getResponse(Http2ResponseDecoder.streamIdToId(stream.id()), true);
        if (res == null) {
            return;
        }
        if (!this.goAwayHandler.receivedGoAway()) {
            res.close(ClosedSessionException.get());
            return;
        }
        int lastStreamId = this.conn.local().lastStreamKnownByPeer();
        if (stream.id() > lastStreamId) {
            res.close(UnprocessedRequestException.get());
        } else {
            res.close(ClosedSessionException.get());
        }
    }

    public void onStreamRemoved(Http2Stream stream) {
    }

    public void onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
        this.goAwayHandler.onGoAwaySent(this.channel(), lastStreamId, errorCode, debugData);
    }

    public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
        this.goAwayHandler.onGoAwayReceived(this.channel(), lastStreamId, errorCode, debugData);
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
        ctx.fireChannelRead((Object)settings);
    }

    public void onSettingsAckRead(ChannelHandlerContext ctx) {
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        HttpResponseDecoder.HttpResponseWrapper res = this.getResponse(Http2ResponseDecoder.streamIdToId(streamId), endOfStream);
        if (res == null) {
            if (this.conn.streamMayHaveExisted(streamId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} Received a late HEADERS frame for a closed stream: {}", (Object)ctx.channel(), (Object)streamId);
                }
                return;
            }
            throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"received a HEADERS frame for an unknown stream: %d", (Object[])new Object[]{streamId});
        }
        HttpHeaders converted = ArmeriaHttpUtil.toArmeria(headers, endOfStream);
        try {
            if (!res.tryWrite(converted)) {
                res.scheduleTimeout(ctx.channel().eventLoop());
            }
        }
        catch (Throwable t) {
            res.close(t);
            throw Http2Exception.connectionError((Http2Error)Http2Error.INTERNAL_ERROR, (Throwable)t, (String)"failed to consume a HEADERS frame", (Object[])new Object[0]);
        }
        if (endOfStream) {
            res.close();
        }
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        int dataLength = data.readableBytes();
        HttpResponseDecoder.HttpResponseWrapper res = this.getResponse(Http2ResponseDecoder.streamIdToId(streamId), endOfStream);
        if (res == null) {
            if (this.conn.streamMayHaveExisted(streamId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} Received a late DATA frame for a closed stream: {}", (Object)ctx.channel(), (Object)streamId);
                }
                return dataLength + padding;
            }
            throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"received a DATA frame for an unknown stream: %d", (Object[])new Object[]{streamId});
        }
        long maxContentLength = res.maxContentLength();
        if (maxContentLength > 0L && res.writtenBytes() > maxContentLength - (long)dataLength) {
            res.close(ContentTooLargeException.get());
            throw Http2Exception.connectionError((Http2Error)Http2Error.INTERNAL_ERROR, (String)"content length too large: %d + %d > %d (stream: %d)", (Object[])new Object[]{res.writtenBytes(), dataLength, maxContentLength, streamId});
        }
        try {
            res.tryWrite(new ByteBufHttpData(data.retain(), endOfStream));
        }
        catch (Throwable t) {
            res.close(t);
            throw Http2Exception.connectionError((Http2Error)Http2Error.INTERNAL_ERROR, (Throwable)t, (String)"failed to consume a DATA frame", (Object[])new Object[0]);
        }
        if (endOfStream) {
            res.close();
        }
        return dataLength + padding;
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
        HttpResponseDecoder.HttpResponseWrapper res = this.removeResponse(Http2ResponseDecoder.streamIdToId(streamId));
        if (res == null) {
            if (this.conn.streamMayHaveExisted(streamId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} Received a late RST_STREAM frame for a closed stream: {}", (Object)ctx.channel(), (Object)streamId);
                }
            } else {
                throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"received a RST_STREAM frame for an unknown stream: %d", (Object[])new Object[]{streamId});
            }
            return;
        }
        res.close(ClosedSessionException.get());
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
    }

    public void onPingRead(ChannelHandlerContext ctx, long data) {
    }

    public void onPingAckRead(ChannelHandlerContext ctx, long data) {
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
    }

    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
    }

    private static int streamIdToId(int streamId) {
        return streamId - 1 >>> 1;
    }

    private static int idToStreamId(int id) {
        return (id << 1) + 1;
    }
}

