/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptionValue;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.HttpClientBuilder;
import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import java.net.URI;
import java.nio.charset.Charset;

public interface HttpClient
extends ClientBuilderParams {
    public static HttpClient of(String uri, ClientOptionValue<?> ... options) {
        return HttpClient.of(ClientFactory.DEFAULT, uri, options);
    }

    public static HttpClient of(String uri, ClientOptions options) {
        return HttpClient.of(ClientFactory.DEFAULT, uri, options);
    }

    public static HttpClient of(ClientFactory factory, String uri, ClientOptionValue<?> ... options) {
        return ((HttpClientBuilder)new HttpClientBuilder(uri).factory(factory).options(options)).build();
    }

    public static HttpClient of(ClientFactory factory, String uri, ClientOptions options) {
        return ((HttpClientBuilder)new HttpClientBuilder(uri).factory(factory).options(options)).build();
    }

    public static HttpClient of(URI uri, ClientOptionValue<?> ... options) {
        return HttpClient.of(ClientFactory.DEFAULT, uri, options);
    }

    public static HttpClient of(URI uri, ClientOptions options) {
        return HttpClient.of(ClientFactory.DEFAULT, uri, options);
    }

    public static HttpClient of(ClientFactory factory, URI uri, ClientOptionValue<?> ... options) {
        return ((HttpClientBuilder)new HttpClientBuilder(uri).factory(factory).options(options)).build();
    }

    public static HttpClient of(ClientFactory factory, URI uri, ClientOptions options) {
        return ((HttpClientBuilder)new HttpClientBuilder(uri).factory(factory).options(options)).build();
    }

    public HttpResponse execute(HttpRequest var1);

    public HttpResponse execute(AggregatedHttpMessage var1);

    default public HttpResponse execute(HttpHeaders headers) {
        return this.execute(AggregatedHttpMessage.of(headers));
    }

    default public HttpResponse execute(HttpHeaders headers, HttpData content) {
        return this.execute(AggregatedHttpMessage.of(headers, content));
    }

    default public HttpResponse execute(HttpHeaders headers, byte[] content) {
        return this.execute(AggregatedHttpMessage.of(headers, HttpData.of(content)));
    }

    default public HttpResponse execute(HttpHeaders headers, String content) {
        return this.execute(AggregatedHttpMessage.of(headers, HttpData.ofUtf8(content)));
    }

    default public HttpResponse execute(HttpHeaders headers, String content, Charset charset) {
        return this.execute(AggregatedHttpMessage.of(headers, HttpData.of(charset, content)));
    }

    default public HttpResponse options(String path) {
        return this.execute(HttpHeaders.of(HttpMethod.OPTIONS, path));
    }

    default public HttpResponse get(String path) {
        return this.execute(HttpHeaders.of(HttpMethod.GET, path));
    }

    default public HttpResponse head(String path) {
        return this.execute(HttpHeaders.of(HttpMethod.HEAD, path));
    }

    default public HttpResponse post(String path, HttpData content) {
        return this.execute(HttpHeaders.of(HttpMethod.POST, path), content);
    }

    default public HttpResponse post(String path, byte[] content) {
        return this.execute(HttpHeaders.of(HttpMethod.POST, path), content);
    }

    default public HttpResponse post(String path, String content) {
        return this.execute(HttpHeaders.of(HttpMethod.POST, path), HttpData.ofUtf8(content));
    }

    default public HttpResponse post(String path, String content, Charset charset) {
        return this.execute(HttpHeaders.of(HttpMethod.POST, path), content, charset);
    }

    default public HttpResponse put(String path, HttpData content) {
        return this.execute(HttpHeaders.of(HttpMethod.PUT, path), content);
    }

    default public HttpResponse put(String path, byte[] content) {
        return this.execute(HttpHeaders.of(HttpMethod.PUT, path), content);
    }

    default public HttpResponse put(String path, String content) {
        return this.execute(HttpHeaders.of(HttpMethod.PUT, path), HttpData.ofUtf8(content));
    }

    default public HttpResponse put(String path, String content, Charset charset) {
        return this.execute(HttpHeaders.of(HttpMethod.PUT, path), content, charset);
    }

    default public HttpResponse patch(String path, HttpData content) {
        return this.execute(HttpHeaders.of(HttpMethod.PATCH, path), content);
    }

    default public HttpResponse patch(String path, byte[] content) {
        return this.execute(HttpHeaders.of(HttpMethod.PATCH, path), content);
    }

    default public HttpResponse patch(String path, String content) {
        return this.execute(HttpHeaders.of(HttpMethod.PATCH, path), HttpData.ofUtf8(content));
    }

    default public HttpResponse patch(String path, String content, Charset charset) {
        return this.execute(HttpHeaders.of(HttpMethod.PATCH, path), content, charset);
    }

    default public HttpResponse delete(String path) {
        return this.execute(HttpHeaders.of(HttpMethod.DELETE, path));
    }

    default public HttpResponse trace(String path) {
        return this.execute(HttpHeaders.of(HttpMethod.TRACE, path));
    }
}

