/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AbstractClientOptionsBuilder;
import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.DecoratingClientFunction;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.net.URI;
import java.util.Objects;
import java.util.function.Function;

public final class HttpClientBuilder
extends AbstractClientOptionsBuilder<HttpClientBuilder> {
    private final URI uri;
    private ClientFactory factory = ClientFactory.DEFAULT;

    public HttpClientBuilder(String uri) {
        this(URI.create(Objects.requireNonNull(uri, "uri")));
    }

    public HttpClientBuilder(URI uri) {
        HttpClientBuilder.validateScheme(Objects.requireNonNull(uri, "uri").getScheme());
        this.uri = URI.create(SerializationFormat.NONE + "+" + uri);
    }

    private static void validateScheme(String scheme) {
        for (SessionProtocol p : SessionProtocol.values()) {
            if (!scheme.equalsIgnoreCase(p.uriText())) continue;
            return;
        }
        throw new IllegalArgumentException("scheme : " + scheme + " (expected: one of " + ImmutableList.copyOf(SessionProtocol.values()) + ')');
    }

    public HttpClientBuilder factory(ClientFactory factory) {
        this.factory = Objects.requireNonNull(factory, "factory");
        return this;
    }

    public HttpClientBuilder decorator(Function<? extends Client<HttpRequest, HttpResponse>, ? extends Client<HttpRequest, HttpResponse>> decorator) {
        return (HttpClientBuilder)this.decorator(HttpRequest.class, HttpResponse.class, decorator);
    }

    public HttpClientBuilder decorator(DecoratingClientFunction<HttpRequest, HttpResponse> decorator) {
        return (HttpClientBuilder)this.decorator(HttpRequest.class, HttpResponse.class, decorator);
    }

    public HttpClient build() {
        return this.factory.newClient(this.uri, HttpClient.class, this.buildOptions());
    }
}

