/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DecodedHttpResponse;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClientFactory;
import com.linecorp.armeria.client.HttpSession;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.client.pool.KeyedChannelPool;
import com.linecorp.armeria.client.pool.PoolKey;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.internal.PathAndQuery;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpClientDelegate
implements Client<HttpRequest, HttpResponse> {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientDelegate.class);
    private final HttpClientFactory factory;
    private final AddressResolverGroup<InetSocketAddress> addressResolverGroup;

    HttpClientDelegate(HttpClientFactory factory, AddressResolverGroup<InetSocketAddress> addressResolverGroup) {
        this.factory = Objects.requireNonNull(factory, "factory");
        this.addressResolverGroup = Objects.requireNonNull(addressResolverGroup, "addressResolverGroup");
    }

    @Override
    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        if (!HttpClientDelegate.isValidPath(req)) {
            IllegalArgumentException cause = new IllegalArgumentException("invalid path: " + req.path());
            HttpClientDelegate.handleEarlyRequestException(ctx, req, cause);
            return HttpResponse.ofFailure(cause);
        }
        Endpoint endpoint = ctx.endpoint().resolve(ctx).withDefaultPort(ctx.sessionProtocol().defaultPort());
        EventLoop eventLoop = ctx.eventLoop();
        DecodedHttpResponse res = new DecodedHttpResponse(eventLoop);
        if (endpoint.hasIpAddr()) {
            this.executeWithIpAddr(ctx, endpoint, endpoint.ipAddr(), req, res);
        } else {
            Future resolveFuture = this.addressResolverGroup.getResolver((EventExecutor)eventLoop).resolve((SocketAddress)InetSocketAddress.createUnresolved(endpoint.host(), endpoint.port()));
            if (resolveFuture.isDone()) {
                this.finishResolve(ctx, endpoint, (Future<InetSocketAddress>)resolveFuture, req, res);
            } else {
                resolveFuture.addListener((GenericFutureListener)((FutureListener)future -> this.finishResolve(ctx, endpoint, (Future<InetSocketAddress>)future, req, res)));
            }
        }
        return res;
    }

    private void finishResolve(ClientRequestContext ctx, Endpoint endpoint, Future<InetSocketAddress> resolveFuture, HttpRequest req, DecodedHttpResponse res) {
        if (resolveFuture.isSuccess()) {
            this.executeWithIpAddr(ctx, endpoint, ((InetSocketAddress)resolveFuture.getNow()).getAddress().getHostAddress(), req, res);
        } else {
            Throwable cause = resolveFuture.cause();
            HttpClientDelegate.handleEarlyRequestException(ctx, req, cause);
            res.close(cause);
        }
    }

    private void executeWithIpAddr(ClientRequestContext ctx, Endpoint endpoint, String ipAddr, HttpRequest req, DecodedHttpResponse res) {
        String host = HttpClientDelegate.extractHost(ctx, req, endpoint);
        PoolKey poolKey = new PoolKey(host, ipAddr, endpoint.port(), ctx.sessionProtocol());
        Future<Channel> channelFuture = this.factory.pool(ctx.eventLoop()).acquire(poolKey);
        if (channelFuture.isDone()) {
            this.finishExecute(ctx, poolKey, channelFuture, req, res);
        } else {
            channelFuture.addListener(future -> this.finishExecute(ctx, poolKey, (Future<Channel>)future, req, res));
        }
    }

    private void finishExecute(ClientRequestContext ctx, PoolKey poolKey, Future<Channel> channelFuture, HttpRequest req, DecodedHttpResponse res) {
        if (channelFuture.isSuccess()) {
            Channel ch = (Channel)channelFuture.getNow();
            this.invoke0(ch, ctx, req, res, poolKey);
        } else {
            Throwable cause = channelFuture.cause();
            HttpClientDelegate.handleEarlyRequestException(ctx, req, cause);
            res.close(cause);
        }
    }

    static String extractHost(ClientRequestContext ctx, HttpRequest req, Endpoint endpoint) {
        String host = HttpClientDelegate.extractHost(ctx.additionalRequestHeaders().authority());
        if (host != null) {
            return host;
        }
        host = HttpClientDelegate.extractHost(req.authority());
        if (host != null) {
            return host;
        }
        return endpoint.host();
    }

    @Nullable
    private static String extractHost(@Nullable String authority) {
        if (Strings.isNullOrEmpty(authority)) {
            return null;
        }
        if (authority.charAt(0) == '[') {
            int closingBracketPos = authority.lastIndexOf(93);
            if (closingBracketPos > 0) {
                return authority.substring(1, closingBracketPos);
            }
            return null;
        }
        int colonPos = authority.lastIndexOf(58);
        if (colonPos > 0) {
            return authority.substring(0, colonPos);
        }
        if (colonPos < 0) {
            return authority;
        }
        return null;
    }

    private static boolean isValidPath(HttpRequest req) {
        return PathAndQuery.parse(req.path()) != null;
    }

    private static void handleEarlyRequestException(ClientRequestContext ctx, HttpRequest req, Throwable cause) {
        req.abort();
        RequestLogBuilder logBuilder = ctx.logBuilder();
        logBuilder.endRequest(cause);
        logBuilder.endResponse(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invoke0(Channel channel, ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res, PoolKey poolKey) {
        KeyedChannelPool<PoolKey> pool = KeyedChannelPool.findPool(channel);
        boolean needsRelease = true;
        try {
            HttpSession session = HttpSession.get(channel);
            res.init(session.inboundTrafficController());
            SessionProtocol sessionProtocol = session.protocol();
            if (sessionProtocol == null) {
                needsRelease = false;
                try {
                    UnprocessedRequestException cause2 = UnprocessedRequestException.get();
                    HttpClientDelegate.handleEarlyRequestException(ctx, req, cause2);
                    res.close(cause2);
                }
                finally {
                    channel.close();
                }
                return;
            }
            if (session.invoke(ctx, req, res)) {
                needsRelease = false;
                if (sessionProtocol.isMultiplex()) {
                    HttpClientDelegate.release(pool, poolKey, channel);
                } else {
                    CompletableFuture<Void> completionFuture = this.factory.useHttp1Pipelining() ? req.completionFuture() : res.completionFuture();
                    completionFuture.whenComplete((ret, cause) -> HttpClientDelegate.release(pool, poolKey, channel));
                }
            }
        }
        finally {
            if (needsRelease) {
                HttpClientDelegate.release(pool, poolKey, channel);
            }
        }
    }

    private static void release(KeyedChannelPool<PoolKey> pool, PoolKey poolKey, Channel channel) {
        try {
            pool.release(poolKey, channel);
        }
        catch (Throwable t) {
            logger.warn("Failed to return a Channel to the pool: {}", (Object)channel, (Object)t);
        }
    }
}

