/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AbstractClientFactory;
import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.DefaultClientBuilderParams;
import com.linecorp.armeria.client.DefaultHttpClient;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.EventLoopScheduler;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.HttpClientDelegate;
import com.linecorp.armeria.client.HttpSession;
import com.linecorp.armeria.client.HttpSessionChannelFactory;
import com.linecorp.armeria.client.pool.DefaultKeyedChannelPool;
import com.linecorp.armeria.client.pool.KeyedChannelPool;
import com.linecorp.armeria.client.pool.KeyedChannelPoolHandler;
import com.linecorp.armeria.client.pool.PoolKey;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.util.ReleasableHolder;
import com.linecorp.armeria.internal.TransportType;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.MapMaker;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.resolver.AddressResolverGroup;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

final class HttpClientFactory
extends AbstractClientFactory {
    private static final Set<Scheme> SUPPORTED_SCHEMES = Arrays.stream(SessionProtocol.values()).map(p -> Scheme.of(SerializationFormat.NONE, p)).collect(ImmutableSet.toImmutableSet());
    private static final Predicate<Channel> POOL_HEALTH_CHECKER = ch -> ch.isActive() && HttpSession.get(ch).isActive();
    private final EventLoopGroup workerGroup;
    private final boolean shutdownWorkerGroupOnClose;
    private final Bootstrap baseBootstrap;
    private final Consumer<? super SslContextBuilder> sslContextCustomizer;
    private final int http2InitialConnectionWindowSize;
    private final int http2InitialStreamWindowSize;
    private final int http2MaxFrameSize;
    private final long http2MaxHeaderListSize;
    private final int http1MaxInitialLineLength;
    private final int http1MaxHeaderSize;
    private final int http1MaxChunkSize;
    private final long idleTimeoutMillis;
    private final boolean useHttp2Preface;
    private final boolean useHttp1Pipelining;
    private final ConnectionPoolListenerImpl connectionPoolListener;
    private MeterRegistry meterRegistry;
    private final ConcurrentMap<EventLoop, KeyedChannelPool<PoolKey>> pools = new MapMaker().weakKeys().makeMap();
    private final HttpClientDelegate clientDelegate;
    private final EventLoopScheduler eventLoopScheduler;
    private final Supplier<EventLoop> eventLoopSupplier = () -> RequestContext.mapCurrent(RequestContext::eventLoop, () -> this.eventLoopGroup().next());

    HttpClientFactory(EventLoopGroup workerGroup, boolean shutdownWorkerGroupOnClose, Map<ChannelOption<?>, Object> channelOptions, Consumer<? super SslContextBuilder> sslContextCustomizer, Function<? super EventLoopGroup, ? extends AddressResolverGroup<? extends InetSocketAddress>> addressResolverGroupFactory, int http2InitialConnectionWindowSize, int http2InitialStreamWindowSize, int http2MaxFrameSize, long http2MaxHeaderListSize, int http1MaxInitialLineLength, int http1MaxHeaderSize, int http1MaxChunkSize, long idleTimeoutMillis, boolean useHttp2Preface, boolean useHttp1Pipelining, KeyedChannelPoolHandler<? super PoolKey> connectionPoolListener, MeterRegistry meterRegistry) {
        AddressResolverGroup<? extends InetSocketAddress> addressResolverGroup = addressResolverGroupFactory.apply((EventLoopGroup)workerGroup);
        Bootstrap baseBootstrap = new Bootstrap();
        baseBootstrap.channel(TransportType.socketChannelType(workerGroup));
        baseBootstrap.resolver(addressResolverGroup);
        channelOptions.forEach((option, value) -> {
            ChannelOption castOption = option;
            baseBootstrap.option(castOption, value);
        });
        this.workerGroup = workerGroup;
        this.shutdownWorkerGroupOnClose = shutdownWorkerGroupOnClose;
        this.baseBootstrap = baseBootstrap;
        this.sslContextCustomizer = sslContextCustomizer;
        this.http2InitialConnectionWindowSize = http2InitialConnectionWindowSize;
        this.http2InitialStreamWindowSize = http2InitialStreamWindowSize;
        this.http2MaxFrameSize = http2MaxFrameSize;
        this.http2MaxHeaderListSize = http2MaxHeaderListSize;
        this.http1MaxInitialLineLength = http1MaxInitialLineLength;
        this.http1MaxHeaderSize = http1MaxHeaderSize;
        this.http1MaxChunkSize = http1MaxChunkSize;
        this.idleTimeoutMillis = idleTimeoutMillis;
        this.useHttp2Preface = useHttp2Preface;
        this.useHttp1Pipelining = useHttp1Pipelining;
        this.connectionPoolListener = new ConnectionPoolListenerImpl(connectionPoolListener);
        this.meterRegistry = meterRegistry;
        this.clientDelegate = new HttpClientDelegate(this, addressResolverGroup);
        this.eventLoopScheduler = new EventLoopScheduler(workerGroup);
    }

    Bootstrap newBootstrap() {
        return this.baseBootstrap.clone();
    }

    Consumer<? super SslContextBuilder> sslContextCustomizer() {
        return this.sslContextCustomizer;
    }

    int http2InitialConnectionWindowSize() {
        return this.http2InitialConnectionWindowSize;
    }

    int http2InitialStreamWindowSize() {
        return this.http2InitialStreamWindowSize;
    }

    int http2MaxFrameSize() {
        return this.http2MaxFrameSize;
    }

    long http2MaxHeaderListSize() {
        return this.http2MaxHeaderListSize;
    }

    int http1MaxInitialLineLength() {
        return this.http1MaxInitialLineLength;
    }

    int http1MaxHeaderSize() {
        return this.http1MaxHeaderSize;
    }

    int http1MaxChunkSize() {
        return this.http1MaxChunkSize;
    }

    long idleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    boolean useHttp2Preface() {
        return this.useHttp2Preface;
    }

    boolean useHttp1Pipelining() {
        return this.useHttp1Pipelining;
    }

    KeyedChannelPoolHandler<? super PoolKey> connectionPoolListener() {
        return this.connectionPoolListener;
    }

    @Override
    public Set<Scheme> supportedSchemes() {
        return SUPPORTED_SCHEMES;
    }

    @Override
    public EventLoopGroup eventLoopGroup() {
        return this.workerGroup;
    }

    @Override
    public Supplier<EventLoop> eventLoopSupplier() {
        return this.eventLoopSupplier;
    }

    @Override
    public ReleasableHolder<EventLoop> acquireEventLoop(Endpoint endpoint) {
        return this.eventLoopScheduler.acquire(endpoint);
    }

    @Override
    public MeterRegistry meterRegistry() {
        return this.meterRegistry;
    }

    @Override
    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
    }

    @Override
    public <T> T newClient(URI uri, Class<T> clientType, ClientOptions options) {
        Scheme scheme = this.validateScheme(uri);
        HttpClientFactory.validateClientType(clientType);
        Client<HttpRequest, HttpResponse> delegate = options.decoration().decorate(HttpRequest.class, HttpResponse.class, this.clientDelegate);
        if (clientType == Client.class) {
            Client<HttpRequest, HttpResponse> castClient = delegate;
            return (T)castClient;
        }
        Endpoint endpoint = HttpClientFactory.newEndpoint(uri);
        if (clientType == HttpClient.class) {
            DefaultHttpClient client;
            DefaultHttpClient castClient = client = this.newHttpClient(uri, scheme, endpoint, options, delegate);
            return (T)castClient;
        }
        throw new IllegalArgumentException("unsupported client type: " + clientType.getName());
    }

    @Override
    public <T> Optional<ClientBuilderParams> clientBuilderParams(T client) {
        return Optional.empty();
    }

    private DefaultHttpClient newHttpClient(URI uri, Scheme scheme, Endpoint endpoint, ClientOptions options, Client<HttpRequest, HttpResponse> delegate) {
        return new DefaultHttpClient((ClientBuilderParams)new DefaultClientBuilderParams(this, uri, HttpClient.class, options), delegate, this.meterRegistry, scheme.sessionProtocol(), endpoint);
    }

    private static void validateClientType(Class<?> clientType) {
        if (clientType != HttpClient.class && clientType != Client.class) {
            throw new IllegalArgumentException("clientType: " + clientType + " (expected: " + HttpClient.class.getSimpleName() + " or " + Client.class.getSimpleName() + ')');
        }
    }

    boolean isClosing() {
        return this.connectionPoolListener.closed;
    }

    @Override
    public void close() {
        this.connectionPoolListener.setClosed();
        Iterator i = this.pools.values().iterator();
        while (i.hasNext()) {
            ((KeyedChannelPool)i.next()).close();
            i.remove();
        }
        if (this.shutdownWorkerGroupOnClose) {
            this.workerGroup.shutdownGracefully().syncUninterruptibly();
        }
    }

    KeyedChannelPool<PoolKey> pool(EventLoop eventLoop) {
        KeyedChannelPool pool = (KeyedChannelPool)this.pools.get(eventLoop);
        if (pool != null) {
            return pool;
        }
        return this.pools.computeIfAbsent(eventLoop, e -> {
            HttpSessionChannelFactory channelFactory = new HttpSessionChannelFactory(this, eventLoop);
            KeyedChannelPoolHandler<? super PoolKey> handler = this.connectionPoolListener();
            return new DefaultKeyedChannelPool<PoolKey>(eventLoop, channelFactory, POOL_HEALTH_CHECKER, handler, true);
        });
    }

    private static final class ConnectionPoolListenerImpl
    implements KeyedChannelPoolHandler<PoolKey> {
        private final KeyedChannelPoolHandler<? super PoolKey> connectionPoolListener;
        private volatile boolean closed;

        ConnectionPoolListenerImpl(KeyedChannelPoolHandler<? super PoolKey> connectionPoolListener) {
            this.connectionPoolListener = connectionPoolListener;
        }

        @Override
        public void channelCreated(PoolKey key, Channel ch) throws Exception {
            if (this.closed) {
                ch.close();
                return;
            }
            this.connectionPoolListener.channelCreated(key, ch);
        }

        @Override
        public void channelAcquired(PoolKey key, Channel ch) throws Exception {
            this.connectionPoolListener.channelAcquired(key, ch);
        }

        @Override
        public void channelReleased(PoolKey key, Channel ch) throws Exception {
            this.connectionPoolListener.channelReleased(key, ch);
        }

        @Override
        public void channelClosed(PoolKey key, Channel ch) throws Exception {
            this.connectionPoolListener.channelClosed(key, ch);
        }

        void setClosed() {
            this.closed = true;
        }
    }
}

