/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.DecodedHttpResponse;
import com.linecorp.armeria.client.Http1ResponseDecoder;
import com.linecorp.armeria.client.Http2ClientConnectionHandler;
import com.linecorp.armeria.client.Http2ResponseDecoder;
import com.linecorp.armeria.client.HttpClientFactory;
import com.linecorp.armeria.client.HttpClientIdleTimeoutHandler;
import com.linecorp.armeria.client.HttpHeaderUtil;
import com.linecorp.armeria.client.HttpSession;
import com.linecorp.armeria.client.HttpSessionHandler;
import com.linecorp.armeria.client.SessionProtocolNegotiationCache;
import com.linecorp.armeria.client.SessionProtocolNegotiationException;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.Http1ClientCodec;
import com.linecorp.armeria.internal.ReadSuppressingHandler;
import com.linecorp.armeria.internal.TrafficLoggingHandler;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpClientPipelineConfigurator
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientPipelineConfigurator.class);
    private static final long UPGRADE_RESPONSE_MAX_LENGTH = 16384L;
    private final HttpClientFactory clientFactory;
    @Nullable
    private final SslContext sslCtx;
    private final HttpPreference httpPreference;
    @Nullable
    private InetSocketAddress remoteAddress;

    HttpClientPipelineConfigurator(HttpClientFactory clientFactory, SessionProtocol sessionProtocol) {
        this.clientFactory = clientFactory;
        if (sessionProtocol == SessionProtocol.HTTP || sessionProtocol == SessionProtocol.HTTPS) {
            this.httpPreference = HttpPreference.HTTP2_PREFERRED;
        } else if (sessionProtocol == SessionProtocol.H1 || sessionProtocol == SessionProtocol.H1C) {
            this.httpPreference = HttpPreference.HTTP1_REQUIRED;
        } else if (sessionProtocol == SessionProtocol.H2 || sessionProtocol == SessionProtocol.H2C) {
            this.httpPreference = HttpPreference.HTTP2_REQUIRED;
        } else {
            throw new Error();
        }
        if (sessionProtocol.isTls()) {
            try {
                SslContextBuilder builder = SslContextBuilder.forClient();
                builder.sslProvider(Flags.useOpenSsl() ? SslProvider.OPENSSL : SslProvider.JDK);
                clientFactory.sslContextCustomizer().accept((SslContextBuilder)builder);
                if (this.httpPreference == HttpPreference.HTTP2_REQUIRED || this.httpPreference == HttpPreference.HTTP2_PREFERRED) {
                    builder.ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2"}));
                }
                this.sslCtx = builder.build();
            }
            catch (SSLException e) {
                throw new IllegalStateException("failed to create an SslContext", e);
            }
        } else {
            this.sslCtx = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        InetSocketAddress inetRemoteAddr;
        this.remoteAddress = inetRemoteAddr = (InetSocketAddress)remoteAddress;
        Channel ch = ctx.channel();
        ChannelPipeline p = ch.pipeline();
        p.addLast(new ChannelHandler[]{new FlushConsolidationHandler()});
        p.addLast(new ChannelHandler[]{ReadSuppressingHandler.INSTANCE});
        try {
            if (this.sslCtx != null) {
                this.configureAsHttps(ch, inetRemoteAddr);
            } else {
                this.configureAsHttp(ch);
            }
        }
        catch (Throwable t) {
            promise.tryFailure(t);
            ctx.close();
        }
        finally {
            if (p.context((ChannelHandler)this) != null) {
                p.remove((ChannelHandler)this);
            }
        }
        ctx.connect(remoteAddress, localAddress, promise);
    }

    private void configureAsHttps(final Channel ch, InetSocketAddress remoteAddr) {
        assert (this.sslCtx != null);
        final ChannelPipeline p = ch.pipeline();
        final SslHandler sslHandler = this.sslCtx.newHandler(ch.alloc(), remoteAddr.getHostString(), remoteAddr.getPort());
        p.addLast(new ChannelHandler[]{HttpClientPipelineConfigurator.configureSslHandler(sslHandler)});
        p.addLast(new ChannelHandler[]{TrafficLoggingHandler.CLIENT});
        p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
            private boolean handshakeFailed;

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                SessionProtocol protocol;
                if (!(evt instanceof SslHandshakeCompletionEvent)) {
                    ctx.fireUserEventTriggered(evt);
                    return;
                }
                SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
                if (!handshakeEvent.isSuccess()) {
                    logger.warn("{} TLS handshake failed:", (Object)ctx.channel(), (Object)handshakeEvent.cause());
                    this.handshakeFailed = true;
                    return;
                }
                if (HttpClientPipelineConfigurator.this.isHttp2Protocol(sslHandler)) {
                    if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP1_REQUIRED) {
                        HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, SessionProtocol.H1, SessionProtocol.H2, "unexpected protocol negotiation result");
                        return;
                    }
                    HttpClientPipelineConfigurator.this.addBeforeSessionHandler(p, (ChannelHandler)HttpClientPipelineConfigurator.this.newHttp2ConnectionHandler(ch));
                    protocol = SessionProtocol.H2;
                } else {
                    if (HttpClientPipelineConfigurator.this.httpPreference != HttpPreference.HTTP1_REQUIRED) {
                        SessionProtocolNegotiationCache.setUnsupported(ctx.channel().remoteAddress(), SessionProtocol.H2);
                    }
                    if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                        HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, SessionProtocol.H2, SessionProtocol.H1, "unexpected protocol negotiation result");
                        return;
                    }
                    HttpClientPipelineConfigurator.this.addBeforeSessionHandler(p, (ChannelHandler)HttpClientPipelineConfigurator.newHttp1Codec(HttpClientPipelineConfigurator.this.clientFactory.http1MaxInitialLineLength(), HttpClientPipelineConfigurator.this.clientFactory.http1MaxHeaderSize(), HttpClientPipelineConfigurator.this.clientFactory.http1MaxChunkSize()));
                    protocol = SessionProtocol.H1;
                }
                HttpClientPipelineConfigurator.this.finishSuccessfully(p, protocol);
                p.remove((ChannelHandler)this);
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                if (this.handshakeFailed && cause instanceof DecoderException && cause.getCause() instanceof SSLException) {
                    return;
                }
                Exceptions.logIfUnexpected(logger, ctx.channel(), cause);
                ctx.close();
            }
        }});
    }

    private static SslHandler configureSslHandler(SslHandler sslHandler) {
        SSLEngine engine = sslHandler.engine();
        SSLParameters params = engine.getSSLParameters();
        params.setEndpointIdentificationAlgorithm("HTTPS");
        engine.setSSLParameters(params);
        return sslHandler;
    }

    private void configureAsHttp(Channel ch) {
        boolean attemptUpgrade;
        final ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{TrafficLoggingHandler.CLIENT});
        switch (this.httpPreference) {
            case HTTP1_REQUIRED: {
                attemptUpgrade = false;
                break;
            }
            case HTTP2_PREFERRED: {
                assert (this.remoteAddress != null);
                attemptUpgrade = !SessionProtocolNegotiationCache.isUnsupported(this.remoteAddress, SessionProtocol.H2C);
                break;
            }
            case HTTP2_REQUIRED: {
                attemptUpgrade = true;
                break;
            }
            default: {
                throw new Error();
            }
        }
        if (attemptUpgrade) {
            Http2ClientConnectionHandler http2Handler = this.newHttp2ConnectionHandler(ch);
            if (this.clientFactory.useHttp2Preface()) {
                pipeline.addLast(new ChannelHandler[]{new DowngradeHandler()});
                pipeline.addLast(new ChannelHandler[]{http2Handler});
            } else {
                Http1ClientCodec http1Codec = HttpClientPipelineConfigurator.newHttp1Codec(this.clientFactory.http1MaxInitialLineLength(), this.clientFactory.http1MaxHeaderSize(), this.clientFactory.http1MaxChunkSize());
                Http2ClientUpgradeCodec http2ClientUpgradeCodec = new Http2ClientUpgradeCodec((Http2ConnectionHandler)http2Handler);
                HttpClientUpgradeHandler http2UpgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)http1Codec, (HttpClientUpgradeHandler.UpgradeCodec)http2ClientUpgradeCodec, (int)Math.min(Integer.MAX_VALUE, 16384L));
                pipeline.addLast(new ChannelHandler[]{http1Codec});
                pipeline.addLast(new ChannelHandler[]{new WorkaroundHandler()});
                pipeline.addLast(new ChannelHandler[]{http2UpgradeHandler});
                pipeline.addLast(new ChannelHandler[]{new UpgradeRequestHandler(http2Handler.responseDecoder())});
            }
        } else {
            pipeline.addLast(new ChannelHandler[]{HttpClientPipelineConfigurator.newHttp1Codec(this.clientFactory.http1MaxInitialLineLength(), this.clientFactory.http1MaxHeaderSize(), this.clientFactory.http1MaxChunkSize())});
            pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    ctx.pipeline().remove((ChannelHandler)this);
                    HttpClientPipelineConfigurator.this.finishSuccessfully(pipeline, SessionProtocol.H1C);
                    ctx.fireChannelActive();
                }
            }});
        }
    }

    void finishSuccessfully(ChannelPipeline pipeline, SessionProtocol protocol) {
        int initialWindow;
        if (protocol == SessionProtocol.H1 || protocol == SessionProtocol.H1C) {
            this.addBeforeSessionHandler(pipeline, (ChannelHandler)new Http1ResponseDecoder(pipeline.channel()));
        } else if ((protocol == SessionProtocol.H2 || protocol == SessionProtocol.H2C) && (initialWindow = this.clientFactory.http2InitialConnectionWindowSize()) > 65535) {
            HttpClientPipelineConfigurator.incrementLocalWindowSize(pipeline, initialWindow - 65535);
        }
        long idleTimeoutMillis = this.clientFactory.idleTimeoutMillis();
        if (idleTimeoutMillis > 0L) {
            pipeline.addFirst(new ChannelHandler[]{new HttpClientIdleTimeoutHandler(idleTimeoutMillis)});
        }
        pipeline.channel().eventLoop().execute(() -> pipeline.fireUserEventTriggered((Object)protocol));
    }

    private static void incrementLocalWindowSize(ChannelPipeline pipeline, int delta) {
        try {
            Http2Connection connection = ((Http2ClientConnectionHandler)pipeline.get(Http2ClientConnectionHandler.class)).connection();
            ((Http2LocalFlowController)connection.local().flowController()).incrementWindowSize(connection.connectionStream(), delta);
        }
        catch (Http2Exception e) {
            logger.warn("Failed to increment local flowController window size: {}", (Object)delta, (Object)e);
        }
    }

    void addBeforeSessionHandler(ChannelPipeline pipeline, ChannelHandler handler) {
        ChannelHandlerContext lastContext = pipeline.lastContext();
        assert (lastContext.handler().getClass() == HttpSessionHandler.class);
        pipeline.addBefore(lastContext.name(), null, handler);
    }

    void finishWithNegotiationFailure(ChannelHandlerContext ctx, SessionProtocol expected, SessionProtocol actual, String reason) {
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.channel().eventLoop().execute(() -> pipeline.fireUserEventTriggered((Object)new SessionProtocolNegotiationException(expected, actual, reason)));
        ctx.close();
    }

    boolean isHttp2Protocol(SslHandler sslHandler) {
        return "h2".equals(sslHandler.applicationProtocol());
    }

    static void retryWithH1C(ChannelHandlerContext ctx) {
        HttpSession.get(ctx.channel()).retryWithH1C();
        ctx.close();
    }

    private Http2ClientConnectionHandler newHttp2ConnectionHandler(Channel ch) {
        boolean validateHeaders = false;
        DefaultHttp2Connection conn = new DefaultHttp2Connection(false);
        DefaultHttp2FrameReader reader = new DefaultHttp2FrameReader(false);
        DefaultHttp2FrameWriter writer = new DefaultHttp2FrameWriter();
        DefaultHttp2ConnectionEncoder encoder = new DefaultHttp2ConnectionEncoder((Http2Connection)conn, (Http2FrameWriter)writer);
        DefaultHttp2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder((Http2Connection)conn, (Http2ConnectionEncoder)encoder, (Http2FrameReader)reader);
        return new Http2ClientConnectionHandler((Http2ConnectionDecoder)decoder, (Http2ConnectionEncoder)encoder, this.http2Settings(), ch, this.clientFactory);
    }

    private Http2Settings http2Settings() {
        int maxFrameSize;
        Http2Settings settings = new Http2Settings();
        int initialWindowSize = this.clientFactory.http2InitialStreamWindowSize();
        if (initialWindowSize != 65535) {
            settings.initialWindowSize(initialWindowSize);
        }
        if ((maxFrameSize = this.clientFactory.http2MaxFrameSize()) != 16384) {
            settings.maxFrameSize(maxFrameSize);
        }
        settings.maxHeaderListSize(this.clientFactory.http2MaxHeaderListSize());
        return settings;
    }

    private static Http1ClientCodec newHttp1Codec(int defaultMaxInitialLineLength, int defaultMaxHeaderSize, int defaultMaxChunkSize) {
        return new Http1ClientCodec(defaultMaxInitialLineLength, defaultMaxHeaderSize, defaultMaxChunkSize){

            public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
                HttpSession.get(ctx.channel()).deactivate();
                super.close(ctx, promise);
            }
        };
    }

    private static final class WorkaroundHandler
    extends ChannelDuplexHandler {
        private static final AsciiString CONNECTION_VALUE = AsciiString.cached((String)"HTTP2-Settings,Upgrade");
        private boolean needsToFilterUpgradeResponse = true;
        private boolean needsToFilterUpgradeRequest = true;

        private WorkaroundHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (this.needsToFilterUpgradeResponse && msg instanceof HttpResponse) {
                HttpHeaders headers;
                this.needsToFilterUpgradeResponse = false;
                HttpResponse res = (HttpResponse)msg;
                if (res.status().code() == HttpResponseStatus.SWITCHING_PROTOCOLS.code() && !(headers = res.headers()).contains((CharSequence)HttpHeaderNames.UPGRADE)) {
                    headers.set((CharSequence)HttpHeaderNames.UPGRADE, (Object)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME);
                }
                if (!this.needsToFilterUpgradeRequest) {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            }
            ctx.fireChannelRead(msg);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (this.needsToFilterUpgradeRequest) {
                this.needsToFilterUpgradeRequest = false;
                FullHttpRequest req = (FullHttpRequest)msg;
                req.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)CONNECTION_VALUE);
                if (!this.needsToFilterUpgradeResponse) {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            }
            super.write(ctx, msg, promise);
        }
    }

    private final class DowngradeHandler
    extends ByteToMessageDecoder {
        private boolean handledResponse;

        private DowngradeHandler() {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            if (in.readableBytes() < 9) {
                return;
            }
            this.handledResponse = true;
            ChannelPipeline p = ctx.pipeline();
            if (!this.isSettingsFrame(in)) {
                SessionProtocolNegotiationCache.setUnsupported(ctx.channel().remoteAddress(), SessionProtocol.H2C);
                if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                    HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, SessionProtocol.H2C, SessionProtocol.H1C, "received a non-HTTP/2 response for the HTTP/2 connection preface");
                } else {
                    HttpClientPipelineConfigurator.retryWithH1C(ctx);
                }
                in.skipBytes(in.readableBytes());
            } else {
                HttpClientPipelineConfigurator.this.finishSuccessfully(p, SessionProtocol.H2C);
            }
            p.remove((ChannelHandler)this);
        }

        private boolean isSettingsFrame(ByteBuf in) {
            int start = in.readerIndex();
            return in.getByte(start + 3) == 4 && (in.getInt(start + 5) & Integer.MAX_VALUE) == 0;
        }

        protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            super.decodeLast(ctx, in, out);
            if (!this.handledResponse) {
                if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                    HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, SessionProtocol.H2C, SessionProtocol.H1C, "too little data to determine the HTTP version");
                } else {
                    HttpClientPipelineConfigurator.retryWithH1C(ctx);
                }
            }
        }
    }

    private final class UpgradeRequestHandler
    extends ChannelInboundHandlerAdapter {
        private final Http2ResponseDecoder responseDecoder;
        @Nullable
        private HttpClientUpgradeHandler.UpgradeEvent upgradeEvt;
        private boolean needsToClose;

        UpgradeRequestHandler(Http2ResponseDecoder responseDecoder) {
            this.responseDecoder = responseDecoder;
        }

        public void channelActive(final ChannelHandlerContext ctx) throws Exception {
            DefaultFullHttpRequest upgradeReq = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.HEAD, "/");
            assert (HttpClientPipelineConfigurator.this.remoteAddress != null);
            String host = HttpHeaderUtil.hostHeader(HttpClientPipelineConfigurator.this.remoteAddress.getHostString(), HttpClientPipelineConfigurator.this.remoteAddress.getPort(), SessionProtocol.H1C.defaultPort());
            upgradeReq.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)host);
            upgradeReq.headers().set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)HttpHeaderUtil.USER_AGENT);
            ctx.writeAndFlush((Object)upgradeReq);
            Http2ResponseDecoder responseDecoder = this.responseDecoder;
            DecodedHttpResponse res = new DecodedHttpResponse(ctx.channel().eventLoop());
            res.init(responseDecoder.inboundTrafficController());
            res.subscribe(new Subscriber<HttpObject>(){
                private boolean notified;

                public void onSubscribe(Subscription s) {
                    s.request(Long.MAX_VALUE);
                }

                public void onNext(HttpObject o) {
                    if (this.notified) {
                        return;
                    }
                    this.notified = true;
                    assert (UpgradeRequestHandler.this.upgradeEvt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL);
                    UpgradeRequestHandler.this.onUpgradeResponse(ctx, true);
                }

                public void onError(Throwable t) {
                    ctx.fireExceptionCaught(t);
                }

                public void onComplete() {
                }
            }, (EventExecutor)ctx.channel().eventLoop());
            responseDecoder.addResponse(0, null, res, RequestLogBuilder.NOOP, 0L, 16384L);
            ctx.fireChannelActive();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (!(evt instanceof HttpClientUpgradeHandler.UpgradeEvent)) {
                ctx.fireUserEventTriggered(evt);
                return;
            }
            HttpClientUpgradeHandler.UpgradeEvent upgradeEvt = (HttpClientUpgradeHandler.UpgradeEvent)evt;
            if (upgradeEvt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_ISSUED) {
                return;
            }
            this.upgradeEvt = upgradeEvt;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            boolean handled = false;
            if (msg instanceof HttpResponse) {
                assert (this.upgradeEvt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED);
                String connection = ((HttpResponse)msg).headers().get((CharSequence)HttpHeaderNames.CONNECTION);
                this.needsToClose = connection != null && Ascii.equalsIgnoreCase("close", connection);
                handled = true;
            }
            if (msg instanceof HttpContent) {
                if (msg instanceof LastHttpContent) {
                    this.onUpgradeResponse(ctx, false);
                }
                handled = true;
            }
            if (!handled) {
                ctx.fireChannelRead(msg);
            } else {
                ReferenceCountUtil.release((Object)msg);
            }
        }

        private void onUpgradeResponse(ChannelHandlerContext ctx, boolean success) {
            HttpClientUpgradeHandler.UpgradeEvent upgradeEvt = this.upgradeEvt;
            assert (upgradeEvt != null) : "received an upgrade response before an UpgradeEvent";
            ChannelPipeline p = ctx.pipeline();
            p.remove((ChannelHandler)this);
            if (this.needsToClose) {
                SessionProtocolNegotiationCache.setUnsupported(ctx.channel().remoteAddress(), SessionProtocol.H2C);
                if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                    HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, SessionProtocol.H2C, SessionProtocol.H1C, "upgrade response with 'Connection: close' header");
                } else {
                    HttpClientPipelineConfigurator.retryWithH1C(ctx);
                }
                return;
            }
            if (success) {
                HttpClientPipelineConfigurator.this.finishSuccessfully(p, SessionProtocol.H2C);
            } else {
                SessionProtocolNegotiationCache.setUnsupported(ctx.channel().remoteAddress(), SessionProtocol.H2C);
                if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                    HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, SessionProtocol.H2C, SessionProtocol.H1C, "upgrade request rejected");
                    return;
                }
                HttpClientPipelineConfigurator.this.finishSuccessfully(p, SessionProtocol.H1C);
            }
        }
    }

    private static enum HttpPreference {
        HTTP1_REQUIRED,
        HTTP2_PREFERRED,
        HTTP2_REQUIRED;

    }
}

