/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.HttpHeaderUtil;
import com.linecorp.armeria.client.HttpResponseDecoder;
import com.linecorp.armeria.client.HttpSession;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.client.WriteTimeoutException;
import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.DefaultHttpHeaders;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.ClosedPublisherException;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.HttpObjectEncoder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpRequestSubscriber
implements ChannelFutureListener,
Subscriber<HttpObject> {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestSubscriber.class);
    private final Channel ch;
    private final HttpObjectEncoder encoder;
    private final int id;
    private final HttpRequest request;
    private final HttpResponseDecoder.HttpResponseWrapper response;
    private final ClientRequestContext reqCtx;
    private final RequestLogBuilder logBuilder;
    private final long timeoutMillis;
    @Nullable
    private Subscription subscription;
    @Nullable
    private ScheduledFuture<?> timeoutFuture;
    private State state = State.NEEDS_TO_WRITE_FIRST_HEADER;
    private boolean isSubscriptionCompleted;

    HttpRequestSubscriber(Channel ch, HttpObjectEncoder encoder, int id, HttpRequest request, HttpResponseDecoder.HttpResponseWrapper response, ClientRequestContext reqCtx, long timeoutMillis) {
        this.ch = ch;
        this.encoder = encoder;
        this.id = id;
        this.request = request;
        this.response = response;
        this.reqCtx = reqCtx;
        this.logBuilder = reqCtx.logBuilder();
        this.timeoutMillis = timeoutMillis;
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        this.cancelTimeout();
        if (future.isSuccess()) {
            if (this.state == State.DONE) {
                this.response.scheduleTimeout(this.ch.eventLoop());
            }
            if (!this.isSubscriptionCompleted) {
                assert (this.subscription != null);
                this.subscription.request(1L);
            }
            return;
        }
        this.fail(future.cause());
        Throwable cause = future.cause();
        if (!(cause instanceof ClosedPublisherException)) {
            Channel ch = future.channel();
            Exceptions.logIfUnexpected(logger, ch, HttpSession.get(ch).protocol(), cause);
            ch.close();
        }
    }

    public void onSubscribe(Subscription subscription) {
        assert (this.subscription == null);
        this.subscription = subscription;
        EventLoop eventLoop = this.ch.eventLoop();
        if (this.timeoutMillis > 0L) {
            this.timeoutFuture = eventLoop.schedule(() -> this.failAndRespond(WriteTimeoutException.get()), this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        this.writeFirstHeader();
    }

    private void writeFirstHeader() {
        HttpSession session = HttpSession.get(this.ch);
        if (!session.isActive()) {
            this.failAndRespond(UnprocessedRequestException.get());
            return;
        }
        HttpHeaders firstHeaders = this.autoFillHeaders(this.ch);
        SessionProtocol protocol = session.protocol();
        assert (protocol != null);
        this.logBuilder.startRequest(this.ch, protocol);
        this.logBuilder.requestHeaders(firstHeaders);
        if (this.request.isEmpty()) {
            this.state = State.DONE;
            this.write0(firstHeaders, true, true);
        } else {
            this.state = State.NEEDS_DATA_OR_TRAILING_HEADERS;
            this.write0(firstHeaders, false, true);
        }
    }

    private HttpHeaders autoFillHeaders(Channel ch) {
        HttpHeaders additionalHeaders;
        HttpHeaders requestHeaders = this.request.headers();
        if (requestHeaders.isImmutable()) {
            HttpHeaders temp = requestHeaders;
            requestHeaders = new DefaultHttpHeaders(false);
            requestHeaders.set(temp);
        }
        if (!(additionalHeaders = this.reqCtx.additionalRequestHeaders()).isEmpty()) {
            requestHeaders.setAllIfAbsent(additionalHeaders);
        }
        SessionProtocol sessionProtocol = this.reqCtx.sessionProtocol();
        if (requestHeaders.authority() == null) {
            String authority;
            InetSocketAddress isa = (InetSocketAddress)ch.remoteAddress();
            String hostname = isa.getHostName();
            int port = isa.getPort();
            if (port == sessionProtocol.defaultPort()) {
                authority = hostname;
            } else {
                StringBuilder buf = new StringBuilder(hostname.length() + 6);
                buf.append(hostname);
                buf.append(':');
                buf.append(port);
                authority = buf.toString();
            }
            requestHeaders.authority(authority);
        }
        if (requestHeaders.scheme() == null) {
            requestHeaders.scheme(sessionProtocol.isTls() ? "https" : "http");
        }
        if (!requestHeaders.contains(HttpHeaderNames.USER_AGENT)) {
            requestHeaders.set(HttpHeaderNames.USER_AGENT, HttpHeaderUtil.USER_AGENT.toString());
        }
        return requestHeaders;
    }

    public void onNext(HttpObject o) {
        if (!(o instanceof HttpData) && !(o instanceof HttpHeaders)) {
            throw this.newIllegalStateException("published an HttpObject that's neither Http2Headers nor Http2Data: " + o);
        }
        boolean endOfStream = o.isEndOfStream();
        switch (this.state) {
            case NEEDS_DATA_OR_TRAILING_HEADERS: {
                if (o instanceof HttpHeaders) {
                    HttpHeaders trailingHeaders = (HttpHeaders)o;
                    if (trailingHeaders.status() != null) {
                        throw this.newIllegalStateException("published a trailing HttpHeaders with status: " + o);
                    }
                    endOfStream = true;
                }
                this.write(o, endOfStream, true);
                return;
            }
            case DONE: {
                this.cancelSubscription();
                ReferenceCountUtil.safeRelease((Object)o);
                return;
            }
        }
    }

    public void onError(Throwable cause) {
        this.isSubscriptionCompleted = true;
        this.failAndRespond(cause);
    }

    public void onComplete() {
        this.isSubscriptionCompleted = true;
        this.cancelTimeout();
        if (this.state != State.DONE) {
            this.write(HttpData.EMPTY_DATA, true, true);
        }
    }

    private void write(HttpObject o, boolean endOfStream, boolean flush) {
        if (!this.ch.isActive()) {
            ReferenceCountUtil.safeRelease((Object)o);
            this.fail(ClosedSessionException.get());
            return;
        }
        if (endOfStream) {
            this.state = State.DONE;
        }
        this.write0(o, endOfStream, flush);
    }

    private void write0(HttpObject o, boolean endOfStream, boolean flush) {
        ChannelFuture future;
        if (o instanceof HttpData) {
            HttpData data = (HttpData)o;
            future = this.encoder.writeData(this.id, this.streamId(), data, endOfStream);
            this.logBuilder.increaseRequestLength(data.length());
        } else if (o instanceof HttpHeaders) {
            future = this.encoder.writeHeaders(this.id, this.streamId(), (HttpHeaders)o, endOfStream);
        } else {
            throw new Error();
        }
        if (endOfStream) {
            this.logBuilder.endRequest();
        }
        future.addListener((GenericFutureListener)this);
        if (flush) {
            this.ch.flush();
        }
    }

    private int streamId() {
        return (this.id << 1) + 1;
    }

    private void fail(Throwable cause) {
        this.state = State.DONE;
        this.logBuilder.endRequest(cause);
        this.logBuilder.endResponse(cause);
        this.cancelSubscription();
    }

    private void cancelSubscription() {
        this.isSubscriptionCompleted = true;
        assert (this.subscription != null);
        this.subscription.cancel();
    }

    private void failAndRespond(Throwable cause) {
        Http2Error error;
        this.fail(cause);
        if (this.response.isOpen()) {
            this.response.close(cause);
            error = Http2Error.INTERNAL_ERROR;
        } else if (cause instanceof WriteTimeoutException || cause instanceof AbortedStreamException) {
            error = Http2Error.CANCEL;
        } else {
            Exceptions.logIfUnexpected(logger, this.ch, HttpSession.get(this.ch).protocol(), "a request publisher raised an exception", cause);
            error = Http2Error.INTERNAL_ERROR;
        }
        if (this.ch.isActive()) {
            this.encoder.writeReset(this.id, this.streamId(), error);
            this.ch.flush();
        }
    }

    private boolean cancelTimeout() {
        ScheduledFuture<?> timeoutFuture = this.timeoutFuture;
        if (timeoutFuture == null) {
            return true;
        }
        this.timeoutFuture = null;
        return timeoutFuture.cancel(false);
    }

    private IllegalStateException newIllegalStateException(String msg) {
        IllegalStateException cause = new IllegalStateException(msg);
        this.fail(cause);
        return cause;
    }

    static enum State {
        NEEDS_TO_WRITE_FIRST_HEADER,
        NEEDS_DATA_OR_TRAILING_HEADERS,
        DONE;

    }
}

