/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.DecodedHttpResponse;
import com.linecorp.armeria.client.ResponseTimeoutException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.stream.AbstractStreamMessageAndWriter;
import com.linecorp.armeria.common.stream.StreamWriter;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.InboundTrafficController;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class HttpResponseDecoder {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponseDecoder.class);
    private final IntObjectMap<HttpResponseWrapper> responses = new IntObjectHashMap();
    private final Channel channel;
    private final InboundTrafficController inboundTrafficController;
    private boolean disconnectWhenFinished;

    HttpResponseDecoder(Channel channel) {
        this.channel = channel;
        this.inboundTrafficController = new InboundTrafficController(channel);
    }

    final Channel channel() {
        return this.channel;
    }

    final InboundTrafficController inboundTrafficController() {
        return this.inboundTrafficController;
    }

    HttpResponseWrapper addResponse(int id, @Nullable HttpRequest req, DecodedHttpResponse res, RequestLogBuilder logBuilder, long responseTimeoutMillis, long maxContentLength) {
        HttpResponseWrapper newRes = new HttpResponseWrapper(req, res, logBuilder, responseTimeoutMillis, maxContentLength);
        HttpResponseWrapper oldRes = (HttpResponseWrapper)this.responses.put(id, (Object)newRes);
        assert (oldRes == null) : "addResponse(" + id + ", " + res + ", " + responseTimeoutMillis + "): " + oldRes;
        return newRes;
    }

    @Nullable
    final HttpResponseWrapper getResponse(int id) {
        return (HttpResponseWrapper)this.responses.get(id);
    }

    @Nullable
    final HttpResponseWrapper getResponse(int id, boolean remove) {
        return remove ? this.removeResponse(id) : this.getResponse(id);
    }

    @Nullable
    final HttpResponseWrapper removeResponse(int id) {
        return (HttpResponseWrapper)this.responses.remove(id);
    }

    final boolean hasUnfinishedResponses() {
        return !this.responses.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void failUnfinishedResponses(Throwable cause) {
        try {
            for (HttpResponseWrapper res : this.responses.values()) {
                res.close(cause);
            }
        }
        finally {
            this.responses.clear();
        }
    }

    final void disconnectWhenFinished() {
        this.disconnectWhenFinished = true;
    }

    final boolean needsToDisconnect() {
        return this.disconnectWhenFinished && !this.hasUnfinishedResponses();
    }

    static final class HttpResponseWrapper
    implements StreamWriter<HttpObject>,
    Runnable {
        @Nullable
        private final HttpRequest request;
        private final DecodedHttpResponse delegate;
        private final RequestLogBuilder logBuilder;
        private final long responseTimeoutMillis;
        private final long maxContentLength;
        @Nullable
        private ScheduledFuture<?> responseTimeoutFuture;

        HttpResponseWrapper(@Nullable HttpRequest request, DecodedHttpResponse delegate, RequestLogBuilder logBuilder, long responseTimeoutMillis, long maxContentLength) {
            this.request = request;
            this.delegate = delegate;
            this.logBuilder = logBuilder;
            this.responseTimeoutMillis = responseTimeoutMillis;
            this.maxContentLength = maxContentLength;
        }

        CompletableFuture<Void> completionFuture() {
            return this.delegate.completionFuture();
        }

        void scheduleTimeout(EventLoop eventLoop) {
            if (this.responseTimeoutFuture != null || this.responseTimeoutMillis <= 0L || !this.isOpen()) {
                return;
            }
            this.responseTimeoutFuture = eventLoop.schedule((Runnable)this, this.responseTimeoutMillis, TimeUnit.MILLISECONDS);
        }

        boolean cancelTimeout() {
            ScheduledFuture<?> responseTimeoutFuture = this.responseTimeoutFuture;
            if (responseTimeoutFuture == null) {
                return true;
            }
            this.responseTimeoutFuture = null;
            return responseTimeoutFuture.cancel(false);
        }

        long maxContentLength() {
            return this.maxContentLength;
        }

        long writtenBytes() {
            return this.delegate.writtenBytes();
        }

        @Override
        public void run() {
            ResponseTimeoutException cause = ResponseTimeoutException.get();
            this.delegate.close(cause);
            this.logBuilder.endResponse(cause);
            if (this.request != null) {
                this.request.abort();
            }
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public boolean tryWrite(HttpObject o) {
            if (o instanceof HttpHeaders) {
                this.logBuilder.startResponse();
                HttpHeaders headers = (HttpHeaders)o;
                HttpStatus status = headers.status();
                if (status != null && status.codeClass() != HttpStatusClass.INFORMATIONAL) {
                    this.logBuilder.responseHeaders(headers);
                }
            } else if (o instanceof HttpData) {
                this.logBuilder.increaseResponseLength(((HttpData)o).length());
            }
            return this.delegate.tryWrite(o);
        }

        @Override
        public boolean tryWrite(Supplier<? extends HttpObject> o) {
            return ((AbstractStreamMessageAndWriter)this.delegate).tryWrite(o);
        }

        @Override
        public CompletableFuture<Void> onDemand(Runnable task) {
            return this.delegate.onDemand(task);
        }

        void onSubscriptionCancelled() {
            this.close(null, this::cancelAction);
        }

        @Override
        public void close() {
            this.close(null, this::closeAction);
        }

        @Override
        public void close(Throwable cause) {
            this.close(cause, this::closeAction);
        }

        private void close(@Nullable Throwable cause, Consumer<Throwable> actionOnTimeoutCancelled) {
            if (this.cancelTimeout()) {
                actionOnTimeoutCancelled.accept(cause);
            } else if (cause != null && !Exceptions.isExpected(cause)) {
                logger.warn("Unexpected exception:", cause);
            }
            if (this.request != null) {
                this.request.abort();
            }
        }

        private void closeAction(@Nullable Throwable cause) {
            if (cause != null) {
                this.delegate.close(cause);
                this.logBuilder.endResponse(cause);
            } else {
                this.delegate.close();
                this.logBuilder.endResponse();
            }
        }

        private void cancelAction(@Nullable Throwable cause) {
            this.logBuilder.endResponse();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

