/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DecodedHttpResponse;
import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.InboundTrafficController;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import javax.annotation.Nullable;

interface HttpSession {
    public static final HttpSession INACTIVE = new HttpSession(){
        private final InboundTrafficController inboundTrafficController = new InboundTrafficController(null, 0, 0);

        @Override
        @Nullable
        public SessionProtocol protocol() {
            return null;
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public InboundTrafficController inboundTrafficController() {
            return this.inboundTrafficController;
        }

        @Override
        public boolean hasUnfinishedResponses() {
            return false;
        }

        @Override
        public boolean invoke(ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
            res.close(ClosedSessionException.get());
            return false;
        }

        @Override
        public void retryWithH1C() {
            throw new IllegalStateException();
        }

        @Override
        public void deactivate() {
        }
    };

    public static HttpSession get(Channel ch) {
        ChannelHandler lastHandler = ch.pipeline().last();
        if (lastHandler instanceof HttpSession) {
            return (HttpSession)lastHandler;
        }
        for (ChannelHandler h : ch.pipeline().toMap().values()) {
            if (!(h instanceof HttpSession)) continue;
            return (HttpSession)h;
        }
        return INACTIVE;
    }

    @Nullable
    public SessionProtocol protocol();

    public boolean isActive();

    public InboundTrafficController inboundTrafficController();

    public boolean hasUnfinishedResponses();

    public boolean invoke(ClientRequestContext var1, HttpRequest var2, DecodedHttpResponse var3);

    public void retryWithH1C();

    public void deactivate();
}

