/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.HttpClientFactory;
import com.linecorp.armeria.client.HttpClientPipelineConfigurator;
import com.linecorp.armeria.client.HttpSessionHandler;
import com.linecorp.armeria.client.SessionProtocolNegotiationCache;
import com.linecorp.armeria.client.SessionProtocolNegotiationException;
import com.linecorp.armeria.client.pool.PoolKey;
import com.linecorp.armeria.common.SessionProtocol;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

class HttpSessionChannelFactory
implements Function<PoolKey, Future<Channel>> {
    private final HttpClientFactory clientFactory;
    private final EventLoop eventLoop;
    private final Bootstrap baseBootstrap;
    private final int connectTimeoutMillis;
    private final Map<SessionProtocol, Bootstrap> bootstrapMap;

    HttpSessionChannelFactory(HttpClientFactory clientFactory, EventLoop eventLoop) {
        this.clientFactory = clientFactory;
        this.eventLoop = eventLoop;
        this.baseBootstrap = clientFactory.newBootstrap();
        this.baseBootstrap.group((EventLoopGroup)eventLoop);
        this.connectTimeoutMillis = (Integer)this.baseBootstrap.config().options().get(ChannelOption.CONNECT_TIMEOUT_MILLIS);
        this.bootstrapMap = Collections.synchronizedMap(new EnumMap(SessionProtocol.class));
    }

    @Override
    public Future<Channel> apply(PoolKey key) {
        InetSocketAddress remoteAddress;
        try {
            remoteAddress = HttpSessionChannelFactory.toRemoteAddress(key);
        }
        catch (UnknownHostException e) {
            return this.eventLoop.newFailedFuture((Throwable)e);
        }
        SessionProtocol protocol = key.sessionProtocol();
        if (SessionProtocolNegotiationCache.isUnsupported(remoteAddress, protocol)) {
            return this.eventLoop.newFailedFuture((Throwable)new SessionProtocolNegotiationException(protocol, "previously failed negotiation"));
        }
        Promise sessionPromise = this.eventLoop.newPromise();
        this.connect(remoteAddress, protocol, (Promise<Channel>)sessionPromise);
        return sessionPromise;
    }

    private static InetSocketAddress toRemoteAddress(PoolKey key) throws UnknownHostException {
        InetAddress inetAddr = InetAddress.getByAddress(key.host(), NetUtil.createByteArrayFromIpAddressString((String)key.ipAddr()));
        return new InetSocketAddress(inetAddr, key.port());
    }

    void connect(SocketAddress remoteAddress, SessionProtocol protocol, Promise<Channel> sessionPromise) {
        Bootstrap bootstrap = this.bootstrap(protocol);
        ChannelFuture connectFuture = bootstrap.connect(remoteAddress);
        connectFuture.addListener(future -> {
            if (future.isSuccess()) {
                this.initSession(protocol, (ChannelFuture)future, sessionPromise);
            } else {
                sessionPromise.setFailure(future.cause());
            }
        });
    }

    private Bootstrap bootstrap(SessionProtocol sessionProtocol) {
        return this.bootstrapMap.computeIfAbsent(sessionProtocol, sp -> {
            Bootstrap bs = this.baseBootstrap.clone();
            bs.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpClientPipelineConfigurator(HttpSessionChannelFactory.this.clientFactory, sp)});
                }
            });
            return bs;
        });
    }

    private void initSession(SessionProtocol protocol, ChannelFuture connectFuture, Promise<Channel> sessionPromise) {
        assert (connectFuture.isSuccess());
        Channel ch = connectFuture.channel();
        EventLoop eventLoop = ch.eventLoop();
        assert (eventLoop.inEventLoop());
        io.netty.util.concurrent.ScheduledFuture timeoutFuture = eventLoop.schedule(() -> {
            if (sessionPromise.tryFailure((Throwable)new SessionProtocolNegotiationException(protocol, "connection established, but session creation timed out: " + ch))) {
                ch.close();
            }
        }, (long)this.connectTimeoutMillis, TimeUnit.MILLISECONDS);
        ch.pipeline().addLast(new ChannelHandler[]{new HttpSessionHandler(this, ch, sessionPromise, (ScheduledFuture<?>)timeoutFuture)});
    }
}

