/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DecodedHttpResponse;
import com.linecorp.armeria.client.Http1ResponseDecoder;
import com.linecorp.armeria.client.Http2ClientConnectionHandler;
import com.linecorp.armeria.client.HttpRequestSubscriber;
import com.linecorp.armeria.client.HttpResponseDecoder;
import com.linecorp.armeria.client.HttpSession;
import com.linecorp.armeria.client.HttpSessionChannelFactory;
import com.linecorp.armeria.client.SessionProtocolNegotiationException;
import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.Http1ObjectEncoder;
import com.linecorp.armeria.internal.Http2ObjectEncoder;
import com.linecorp.armeria.internal.HttpObjectEncoder;
import com.linecorp.armeria.internal.InboundTrafficController;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpSessionHandler
extends ChannelDuplexHandler
implements HttpSession {
    private static final Logger logger = LoggerFactory.getLogger(HttpSessionHandler.class);
    private static final int MAX_NUM_REQUESTS_SENT = 0x20000000;
    private final HttpSessionChannelFactory channelFactory;
    private final Channel channel;
    private final Promise<Channel> sessionPromise;
    private final ScheduledFuture<?> sessionTimeoutFuture;
    private volatile boolean active;
    @Nullable
    private SessionProtocol protocol;
    @Nullable
    private HttpResponseDecoder responseDecoder;
    @Nullable
    private HttpObjectEncoder requestEncoder;
    private int numRequestsSent;
    private boolean needsRetryWithH1C;

    HttpSessionHandler(HttpSessionChannelFactory channelFactory, Channel channel, Promise<Channel> sessionPromise, ScheduledFuture<?> sessionTimeoutFuture) {
        this.channelFactory = Objects.requireNonNull(channelFactory, "channelFactory");
        this.channel = Objects.requireNonNull(channel, "channel");
        this.sessionPromise = Objects.requireNonNull(sessionPromise, "sessionPromise");
        this.sessionTimeoutFuture = Objects.requireNonNull(sessionTimeoutFuture, "sessionTimeoutFuture");
    }

    @Override
    public SessionProtocol protocol() {
        return this.protocol;
    }

    @Override
    public InboundTrafficController inboundTrafficController() {
        assert (this.responseDecoder != null);
        return this.responseDecoder.inboundTrafficController();
    }

    @Override
    public boolean hasUnfinishedResponses() {
        assert (this.responseDecoder != null);
        return this.responseDecoder.hasUnfinishedResponses();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean invoke(ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
        if (this.handleEarlyCancellation(ctx, req, res)) {
            return true;
        }
        long writeTimeoutMillis = ctx.writeTimeoutMillis();
        long responseTimeoutMillis = ctx.responseTimeoutMillis();
        long maxContentLength = ctx.maxResponseLength();
        assert (this.responseDecoder != null);
        assert (this.requestEncoder != null);
        int numRequestsSent = ++this.numRequestsSent;
        HttpResponseDecoder.HttpResponseWrapper wrappedRes = this.responseDecoder.addResponse(numRequestsSent, req, res, ctx.logBuilder(), responseTimeoutMillis, maxContentLength);
        req.subscribe(new HttpRequestSubscriber(this.channel, this.requestEncoder, numRequestsSent, req, wrappedRes, ctx, writeTimeoutMillis), (EventExecutor)this.channel.eventLoop(), true);
        if (numRequestsSent >= 0x20000000) {
            this.responseDecoder.disconnectWhenFinished();
            return false;
        }
        return true;
    }

    private boolean handleEarlyCancellation(ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
        if (res.isOpen()) {
            return false;
        }
        assert (this.protocol != null);
        req.abort();
        ctx.logBuilder().startRequest(this.channel, this.protocol);
        ctx.logBuilder().requestHeaders(req.headers());
        req.completionFuture().whenComplete((unused, cause) -> {
            if (cause == null) {
                ctx.logBuilder().endRequest();
            } else {
                ctx.logBuilder().endRequest((Throwable)cause);
            }
        });
        res.completionFuture().whenComplete((unused, cause) -> {
            if (cause == null) {
                ctx.logBuilder().endResponse();
            } else {
                ctx.logBuilder().endResponse((Throwable)cause);
            }
        });
        return true;
    }

    @Override
    public void retryWithH1C() {
        this.needsRetryWithH1C = true;
    }

    @Override
    public void deactivate() {
        this.active = false;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.active = this.channel.isActive();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.active = true;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof Http2Settings)) {
            try {
                String typeInfo = msg instanceof ByteBuf ? msg + " HexDump: " + ByteBufUtil.hexDump((ByteBuf)((ByteBuf)msg)) : String.valueOf(msg);
                throw new IllegalStateException("unexpected message type: " + typeInfo);
            }
            catch (Throwable throwable) {
                ReferenceCountUtil.release((Object)msg);
                throw throwable;
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SessionProtocol) {
            SessionProtocol protocol;
            assert (this.protocol == null);
            assert (this.responseDecoder == null);
            this.sessionTimeoutFuture.cancel(false);
            this.protocol = protocol = (SessionProtocol)((Object)evt);
            if (protocol == SessionProtocol.H1 || protocol == SessionProtocol.H1C) {
                this.requestEncoder = new Http1ObjectEncoder(this.channel, false, protocol.isTls());
                this.responseDecoder = (HttpResponseDecoder)ctx.pipeline().get(Http1ResponseDecoder.class);
            } else if (protocol == SessionProtocol.H2 || protocol == SessionProtocol.H2C) {
                Http2ConnectionHandler handler = (Http2ConnectionHandler)ctx.pipeline().get(Http2ConnectionHandler.class);
                this.requestEncoder = new Http2ObjectEncoder(ctx, handler.encoder());
                this.responseDecoder = ((Http2ClientConnectionHandler)ctx.pipeline().get(Http2ClientConnectionHandler.class)).responseDecoder();
            } else {
                throw new Error();
            }
            if (!this.sessionPromise.trySuccess((Object)this.channel)) {
                ctx.close();
            }
            return;
        }
        if (evt instanceof SessionProtocolNegotiationException) {
            this.sessionTimeoutFuture.cancel(false);
            this.sessionPromise.tryFailure((Throwable)((SessionProtocolNegotiationException)evt));
            ctx.close();
            return;
        }
        if (evt instanceof Http2ConnectionPrefaceAndSettingsFrameWrittenEvent || evt instanceof SslCloseCompletionEvent || evt instanceof ChannelInputShutdownReadComplete) {
            return;
        }
        logger.warn("{} Unexpected user event: {}", (Object)this.channel, evt);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.active = false;
        if (this.needsRetryWithH1C) {
            assert (this.responseDecoder == null || !this.responseDecoder.hasUnfinishedResponses());
            this.sessionTimeoutFuture.cancel(false);
            this.channelFactory.connect(this.channel.remoteAddress(), SessionProtocol.H1C, this.sessionPromise);
        } else {
            this.failUnfinishedResponses(ClosedSessionException.get());
            this.sessionTimeoutFuture.cancel(false);
            this.sessionPromise.tryFailure((Throwable)ClosedSessionException.get());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Exceptions.logIfUnexpected(logger, this.channel, this.protocol(), cause);
        if (this.channel.isActive()) {
            ctx.close();
        }
    }

    private void failUnfinishedResponses(Throwable e) {
        HttpResponseDecoder responseDecoder = this.responseDecoder;
        if (responseDecoder == null) {
            return;
        }
        responseDecoder.failUnfinishedResponses(e);
    }
}

