/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DefaultClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.util.ReleasableHolder;
import com.linecorp.armeria.common.util.SafeCloseable;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.channel.EventLoop;
import java.net.URI;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

public abstract class UserClient<I extends Request, O extends Response>
implements ClientBuilderParams {
    private final ClientBuilderParams params;
    private final Client<I, O> delegate;
    private final MeterRegistry meterRegistry;
    private final SessionProtocol sessionProtocol;
    private final Endpoint endpoint;

    protected UserClient(ClientBuilderParams params, Client<I, O> delegate, MeterRegistry meterRegistry, SessionProtocol sessionProtocol, Endpoint endpoint) {
        this.params = params;
        this.delegate = delegate;
        this.meterRegistry = meterRegistry;
        this.sessionProtocol = sessionProtocol;
        this.endpoint = endpoint;
    }

    @Override
    public ClientFactory factory() {
        return this.params.factory();
    }

    @Override
    public URI uri() {
        return this.params.uri();
    }

    @Override
    public Class<?> clientType() {
        return this.params.clientType();
    }

    @Override
    public final ClientOptions options() {
        return this.params.options();
    }

    protected final <U extends Client<I, O>> U delegate() {
        return (U)this.delegate;
    }

    protected final SessionProtocol sessionProtocol() {
        return this.sessionProtocol;
    }

    protected final Endpoint endpoint() {
        return this.endpoint;
    }

    protected final O execute(HttpMethod method, String path, @Nullable String query, @Nullable String fragment, I req, BiFunction<ClientRequestContext, Throwable, O> fallback) {
        return this.execute(null, method, path, query, fragment, req, fallback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final O execute(@Nullable EventLoop eventLoop, HttpMethod method, String path, @Nullable String query, @Nullable String fragment, I req, BiFunction<ClientRequestContext, Throwable, O> fallback) {
        DefaultClientRequestContext ctx;
        if (eventLoop == null) {
            ReleasableHolder<EventLoop> releasableEventLoop = this.factory().acquireEventLoop(this.endpoint);
            ctx = new DefaultClientRequestContext(releasableEventLoop.get(), this.meterRegistry, this.sessionProtocol, this.endpoint, method, path, query, fragment, this.options(), (Request)req);
            ctx.log().addListener(log -> releasableEventLoop.release(), RequestLogAvailability.COMPLETE);
        } else {
            ctx = new DefaultClientRequestContext(eventLoop, this.meterRegistry, this.sessionProtocol, this.endpoint, method, path, query, fragment, this.options(), (Request)req);
        }
        try (SafeCloseable ignored = ctx.push();){
            Object throwable3 = this.delegate().execute(ctx, req);
            return throwable3;
        }
        catch (Throwable cause) {
            Response fallbackRes = (Response)fallback.apply(ctx, cause);
            RequestLogBuilder logBuilder = ctx.logBuilder();
            if (!ctx.log().isAvailable(RequestLogAvailability.REQUEST_START)) {
                logBuilder.endRequest(cause);
            }
            logBuilder.endResponse(cause);
            return (O)fallbackRes;
        }
    }
}

