/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.circuitbreaker;

import com.linecorp.armeria.client.circuitbreaker.CircuitBreaker;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerConfig;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerListener;
import com.linecorp.armeria.client.circuitbreaker.NonBlockingCircuitBreaker;
import com.linecorp.armeria.internal.shaded.guava.base.Ticker;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class CircuitBreakerBuilder {
    private final Optional<String> name;
    private double failureRateThreshold = 0.8;
    private long minimumRequestThreshold = 10L;
    private Duration trialRequestInterval = Defaults.access$000();
    private Duration circuitOpenWindow = Defaults.access$100();
    private Duration counterSlidingWindow = Defaults.access$200();
    private Duration counterUpdateInterval = Defaults.access$300();
    private Ticker ticker = Defaults.access$400();
    private List<CircuitBreakerListener> listeners = Collections.emptyList();

    public CircuitBreakerBuilder(String name) {
        Objects.requireNonNull(name, "name");
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name: <empty> (expected: a non-empty string)");
        }
        this.name = Optional.of(name);
    }

    public CircuitBreakerBuilder() {
        this.name = Optional.empty();
    }

    public CircuitBreakerBuilder failureRateThreshold(double failureRateThreshold) {
        if (failureRateThreshold <= 0.0 || 1.0 < failureRateThreshold) {
            throw new IllegalArgumentException("failureRateThreshold: " + failureRateThreshold + " (expected: > 0 and <= 1)");
        }
        this.failureRateThreshold = failureRateThreshold;
        return this;
    }

    public CircuitBreakerBuilder minimumRequestThreshold(long minimumRequestThreshold) {
        if (minimumRequestThreshold < 0L) {
            throw new IllegalArgumentException("minimumRequestThreshold: " + minimumRequestThreshold + " (expected: >= 0)");
        }
        this.minimumRequestThreshold = minimumRequestThreshold;
        return this;
    }

    public CircuitBreakerBuilder trialRequestInterval(Duration trialRequestInterval) {
        Objects.requireNonNull(trialRequestInterval, "trialRequestInterval");
        if (trialRequestInterval.isNegative() || trialRequestInterval.isZero()) {
            throw new IllegalArgumentException("trialRequestInterval: " + trialRequestInterval + " (expected: > 0)");
        }
        this.trialRequestInterval = trialRequestInterval;
        return this;
    }

    public CircuitBreakerBuilder trialRequestIntervalMillis(long trialRequestIntervalMillis) {
        this.trialRequestInterval(Duration.ofMillis(trialRequestIntervalMillis));
        return this;
    }

    public CircuitBreakerBuilder circuitOpenWindow(Duration circuitOpenWindow) {
        Objects.requireNonNull(circuitOpenWindow, "circuitOpenWindow");
        if (circuitOpenWindow.isNegative() || circuitOpenWindow.isZero()) {
            throw new IllegalArgumentException("circuitOpenWindow: " + circuitOpenWindow + " (expected: > 0)");
        }
        this.circuitOpenWindow = circuitOpenWindow;
        return this;
    }

    public CircuitBreakerBuilder circuitOpenWindowMillis(long circuitOpenWindowMillis) {
        this.circuitOpenWindow(Duration.ofMillis(circuitOpenWindowMillis));
        return this;
    }

    public CircuitBreakerBuilder counterSlidingWindow(Duration counterSlidingWindow) {
        Objects.requireNonNull(counterSlidingWindow, "counterSlidingWindow");
        if (counterSlidingWindow.isNegative() || counterSlidingWindow.isZero()) {
            throw new IllegalArgumentException("counterSlidingWindow: " + counterSlidingWindow + " (expected: > 0)");
        }
        this.counterSlidingWindow = counterSlidingWindow;
        return this;
    }

    public CircuitBreakerBuilder counterSlidingWindowMillis(long counterSlidingWindowMillis) {
        this.counterSlidingWindow(Duration.ofMillis(counterSlidingWindowMillis));
        return this;
    }

    public CircuitBreakerBuilder counterUpdateInterval(Duration counterUpdateInterval) {
        Objects.requireNonNull(counterUpdateInterval, "counterUpdateInterval");
        if (counterUpdateInterval.isNegative() || counterUpdateInterval.isZero()) {
            throw new IllegalArgumentException("counterUpdateInterval: " + counterUpdateInterval + " (expected: > 0)");
        }
        this.counterUpdateInterval = counterUpdateInterval;
        return this;
    }

    public CircuitBreakerBuilder counterUpdateIntervalMillis(long counterUpdateIntervalMillis) {
        this.counterUpdateInterval(Duration.ofMillis(counterUpdateIntervalMillis));
        return this;
    }

    public CircuitBreakerBuilder listener(CircuitBreakerListener listener) {
        Objects.requireNonNull(listener, "listener");
        if (this.listeners.isEmpty()) {
            this.listeners = new ArrayList<CircuitBreakerListener>(3);
        }
        this.listeners.add(listener);
        return this;
    }

    CircuitBreakerBuilder ticker(Ticker ticker) {
        this.ticker = Objects.requireNonNull(ticker, "ticker");
        return this;
    }

    public CircuitBreaker build() {
        if (this.counterSlidingWindow.compareTo(this.counterUpdateInterval) <= 0) {
            throw new IllegalStateException("counterSlidingWindow: " + this.counterSlidingWindow + " (expected: > counterUpdateInterval)");
        }
        return new NonBlockingCircuitBreaker(this.ticker, new CircuitBreakerConfig(this.name, this.failureRateThreshold, this.minimumRequestThreshold, this.circuitOpenWindow, this.trialRequestInterval, this.counterSlidingWindow, this.counterUpdateInterval, Collections.unmodifiableList(this.listeners)));
    }

    private static final class Defaults {
        private static final double FAILURE_RATE_THRESHOLD = 0.8;
        private static final long MINIMUM_REQUEST_THRESHOLD = 10L;
        private static final Duration TRIAL_REQUEST_INTERVAL = Duration.ofSeconds(3L);
        private static final Duration CIRCUIT_OPEN_WINDOW = Duration.ofSeconds(10L);
        private static final Duration COUNTER_SLIDING_WINDOW = Duration.ofSeconds(20L);
        private static final Duration COUNTER_UPDATE_INTERVAL = Duration.ofSeconds(1L);
        private static final Ticker TICKER = Ticker.systemTicker();

        private Defaults() {
        }

        static /* synthetic */ Duration access$000() {
            return TRIAL_REQUEST_INTERVAL;
        }

        static /* synthetic */ Duration access$100() {
            return CIRCUIT_OPEN_WINDOW;
        }

        static /* synthetic */ Duration access$200() {
            return COUNTER_SLIDING_WINDOW;
        }

        static /* synthetic */ Duration access$300() {
            return COUNTER_UPDATE_INTERVAL;
        }

        static /* synthetic */ Ticker access$400() {
            return TICKER;
        }
    }
}

