/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.circuitbreaker;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.SimpleDecoratingClient;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreaker;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerMapping;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerStrategy;
import com.linecorp.armeria.client.circuitbreaker.FailFastException;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.util.CompletionActions;
import com.linecorp.armeria.common.util.Functions;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CircuitBreakerClient<I extends Request, O extends Response>
extends SimpleDecoratingClient<I, O> {
    private static final Logger logger = LoggerFactory.getLogger(CircuitBreakerClient.class);
    private final CircuitBreakerStrategy<O> strategy;
    private final CircuitBreakerMapping mapping;

    protected CircuitBreakerClient(Client<I, O> delegate, CircuitBreakerMapping mapping, CircuitBreakerStrategy<O> strategy) {
        super(delegate);
        this.mapping = Objects.requireNonNull(mapping, "mapping");
        this.strategy = Objects.requireNonNull(strategy, "strategy");
    }

    protected final CircuitBreakerStrategy<O> strategy() {
        return this.strategy;
    }

    @Override
    public O execute(ClientRequestContext ctx, I req) throws Exception {
        CircuitBreaker circuitBreaker;
        try {
            circuitBreaker = this.mapping.get(ctx, (Request)req);
        }
        catch (Throwable t) {
            logger.warn("Failed to get a circuit breaker from mapping", t);
            return this.delegate().execute(ctx, req);
        }
        if (circuitBreaker.canRequest()) {
            return this.doExecute(ctx, req, circuitBreaker);
        }
        throw new FailFastException(circuitBreaker);
    }

    protected abstract O doExecute(ClientRequestContext var1, I var2, CircuitBreaker var3) throws Exception;

    protected static void reportSuccessOrFailure(CircuitBreaker circuitBreaker, CompletionStage<Boolean> future) {
        future.handle(Functions.voidFunction((success, unused) -> {
            if (success != null) {
                if (success.booleanValue()) {
                    circuitBreaker.onSuccess();
                } else {
                    circuitBreaker.onFailure();
                }
            }
        })).exceptionally(CompletionActions::log);
    }
}

