/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.circuitbreaker;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreaker;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerClient;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerMapping;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerStrategy;
import com.linecorp.armeria.client.circuitbreaker.KeyedCircuitBreakerMapping;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpResponseDuplicator;
import com.linecorp.armeria.common.Request;
import io.netty.util.concurrent.EventExecutor;
import java.util.function.Function;

public final class CircuitBreakerHttpClient
extends CircuitBreakerClient<HttpRequest, HttpResponse> {
    public static Function<Client<HttpRequest, HttpResponse>, CircuitBreakerHttpClient> newDecorator(CircuitBreaker circuitBreaker, CircuitBreakerStrategy<HttpResponse> strategy) {
        return CircuitBreakerHttpClient.newDecorator((ClientRequestContext ctx, Request req) -> circuitBreaker, strategy);
    }

    public static Function<Client<HttpRequest, HttpResponse>, CircuitBreakerHttpClient> newDecorator(CircuitBreakerMapping mapping, CircuitBreakerStrategy<HttpResponse> strategy) {
        return delegate -> new CircuitBreakerHttpClient((Client<HttpRequest, HttpResponse>)delegate, mapping, strategy);
    }

    public static Function<Client<HttpRequest, HttpResponse>, CircuitBreakerHttpClient> newPerMethodDecorator(Function<String, CircuitBreaker> factory, CircuitBreakerStrategy<HttpResponse> strategy) {
        return CircuitBreakerHttpClient.newDecorator(new KeyedCircuitBreakerMapping<String>(KeyedCircuitBreakerMapping.KeySelector.METHOD, factory), strategy);
    }

    public static Function<Client<HttpRequest, HttpResponse>, CircuitBreakerHttpClient> newPerHostDecorator(Function<String, CircuitBreaker> factory, CircuitBreakerStrategy<HttpResponse> strategy) {
        return CircuitBreakerHttpClient.newDecorator(new KeyedCircuitBreakerMapping<String>(KeyedCircuitBreakerMapping.KeySelector.HOST, factory), strategy);
    }

    public static Function<Client<HttpRequest, HttpResponse>, CircuitBreakerHttpClient> newPerHostAndMethodDecorator(Function<String, CircuitBreaker> factory, CircuitBreakerStrategy<HttpResponse> strategy) {
        return CircuitBreakerHttpClient.newDecorator(new KeyedCircuitBreakerMapping<String>(KeyedCircuitBreakerMapping.KeySelector.HOST_AND_METHOD, factory), strategy);
    }

    CircuitBreakerHttpClient(Client<HttpRequest, HttpResponse> delegate, CircuitBreakerMapping mapping, CircuitBreakerStrategy<HttpResponse> strategy) {
        super(delegate, mapping, strategy);
    }

    @Override
    protected HttpResponse doExecute(ClientRequestContext ctx, HttpRequest req, CircuitBreaker circuitBreaker) throws Exception {
        HttpResponse response;
        try {
            response = (HttpResponse)this.delegate().execute(ctx, (HttpRequest)req);
        }
        catch (Throwable cause) {
            CircuitBreakerHttpClient.reportSuccessOrFailure(circuitBreaker, this.strategy().shouldReportAsSuccess(HttpResponse.ofFailure(cause)));
            throw cause;
        }
        HttpResponseDuplicator resDuplicator = new HttpResponseDuplicator(response, CircuitBreakerHttpClient.maxSignalLength(ctx.maxResponseLength()), (EventExecutor)ctx.eventLoop());
        CircuitBreakerHttpClient.reportSuccessOrFailure(circuitBreaker, this.strategy().shouldReportAsSuccess((HttpResponse)resDuplicator.duplicateStream()));
        return (HttpResponse)resDuplicator.duplicateStream(true);
    }

    private static int maxSignalLength(long maxResponseLength) {
        if (maxResponseLength == 0L || maxResponseLength > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)maxResponseLength;
    }
}

