/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.circuitbreaker;

import com.linecorp.armeria.client.circuitbreaker.CircuitState;
import com.linecorp.armeria.client.circuitbreaker.EventCount;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

final class CircuitBreakerMetrics {
    private final AtomicReference<EventCount> latestEventCount = new AtomicReference<EventCount>(EventCount.ZERO);
    private final Counter transitionsToClosed;
    private final Counter transitionsToOpen;
    private final Counter transitionsToHalfOpen;
    private final Counter rejectedRequests;

    CircuitBreakerMetrics(MeterRegistry parent, MeterIdPrefix idPrefix) {
        Objects.requireNonNull(parent, "parent");
        Objects.requireNonNull(idPrefix, "idPrefix");
        String requests = idPrefix.name("requests");
        parent.gauge(requests, idPrefix.tags("result", "success"), this.latestEventCount, lec -> ((EventCount)lec.get()).success());
        parent.gauge(requests, idPrefix.tags("result", "failure"), this.latestEventCount, lec -> ((EventCount)lec.get()).failure());
        String transitions = idPrefix.name("transitions");
        this.transitionsToClosed = parent.counter(transitions, idPrefix.tags("state", CircuitState.CLOSED.name()));
        this.transitionsToOpen = parent.counter(transitions, idPrefix.tags("state", CircuitState.OPEN.name()));
        this.transitionsToHalfOpen = parent.counter(transitions, idPrefix.tags("state", CircuitState.HALF_OPEN.name()));
        this.rejectedRequests = parent.counter(idPrefix.name("rejectedRequests"), idPrefix.tags());
    }

    void onStateChanged(CircuitState state) {
        switch (state) {
            case CLOSED: {
                this.transitionsToClosed.increment();
                break;
            }
            case OPEN: {
                this.transitionsToOpen.increment();
                break;
            }
            case HALF_OPEN: {
                this.transitionsToHalfOpen.increment();
                break;
            }
            default: {
                throw new Error("unknown circuit state: " + (Object)((Object)state));
            }
        }
    }

    void onCountUpdated(EventCount count) {
        this.latestEventCount.set(count);
    }

    void onRequestRejected() {
        this.rejectedRequests.increment();
    }
}

