/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.circuitbreaker;

public final class EventCount {
    public static final EventCount ZERO = new EventCount(0L, 0L);
    private final long success;
    private final long failure;

    public EventCount(long success, long failure) {
        this.success = success;
        this.failure = failure;
        assert (0L <= success);
        assert (0L <= failure);
    }

    public long success() {
        return this.success;
    }

    public long failure() {
        return this.failure;
    }

    public long total() {
        return this.success + this.failure;
    }

    public double successRate() {
        long total = this.total();
        if (total == 0L) {
            throw new ArithmeticException("Failed to calculate success rate since total count is 0");
        }
        return (double)this.success / (double)total;
    }

    public double failureRate() {
        long total = this.total();
        if (total == 0L) {
            throw new ArithmeticException("Failed to calculate failure rate since total count is 0");
        }
        return (double)this.failure / (double)total;
    }

    public String toString() {
        long total = this.total();
        if (total == 0L) {
            return "success% = NaN (0/0)";
        }
        double percentageOfSuccess = 100.0 * this.successRate();
        return String.format("success%% = %.2f%% (%d/%d)", percentageOfSuccess, this.success(), total);
    }

    public int hashCode() {
        return (int)(31L * this.success + this.failure);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventCount)) {
            return false;
        }
        EventCount that = (EventCount)o;
        return this.success == that.success && this.failure == that.failure;
    }
}

