/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.circuitbreaker;

import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerStrategy;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.internal.HttpHeaderSubscriber;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

final class HttpStatusBasedCircuitBreakerStrategy
implements CircuitBreakerStrategy<HttpResponse> {
    private final BiFunction<HttpStatus, Throwable, Boolean> function;

    HttpStatusBasedCircuitBreakerStrategy(BiFunction<HttpStatus, Throwable, Boolean> function) {
        this.function = Objects.requireNonNull(function, "function");
    }

    @Override
    public CompletionStage<Boolean> shouldReportAsSuccess(HttpResponse response) {
        CompletableFuture<HttpHeaders> future = new CompletableFuture<HttpHeaders>();
        HttpHeaderSubscriber subscriber = new HttpHeaderSubscriber(future);
        response.completionFuture().whenComplete((BiConsumer)subscriber);
        response.subscribe(subscriber);
        return future.handle((headers, thrown) -> {
            if (thrown instanceof UnprocessedRequestException) {
                return null;
            }
            return this.function.apply(headers != null ? headers.status() : null, (Throwable)thrown);
        });
    }
}

