/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.circuitbreaker;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreaker;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerMapping;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RpcRequest;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class KeyedCircuitBreakerMapping<K>
implements CircuitBreakerMapping {
    private final ConcurrentMap<K, CircuitBreaker> mapping = new ConcurrentHashMap<K, CircuitBreaker>();
    private final KeySelector<K> keySelector;
    private final Function<K, CircuitBreaker> factory;

    public KeyedCircuitBreakerMapping(KeySelector<K> keySelector, Function<K, CircuitBreaker> factory) {
        this.keySelector = Objects.requireNonNull(keySelector, "keySelector");
        this.factory = Objects.requireNonNull(factory, "factory");
    }

    @Override
    public CircuitBreaker get(ClientRequestContext ctx, Request req) throws Exception {
        K key = this.keySelector.get(ctx, req);
        CircuitBreaker circuitBreaker = (CircuitBreaker)this.mapping.get(key);
        if (circuitBreaker != null) {
            return circuitBreaker;
        }
        return this.mapping.computeIfAbsent(key, mapKey -> this.factory.apply(key));
    }

    @FunctionalInterface
    public static interface KeySelector<K> {
        public static final KeySelector<String> METHOD = (ctx, req) -> req instanceof RpcRequest ? ((RpcRequest)req).method() : ctx.method().name();
        public static final KeySelector<String> HOST = (ctx, req) -> {
            Endpoint endpoint = ctx.endpoint();
            if (endpoint.isGroup()) {
                return endpoint.authority();
            }
            String ipAddr = endpoint.ipAddr();
            if (ipAddr == null || endpoint.isIpAddrOnly()) {
                return endpoint.authority();
            }
            return endpoint.authority() + '/' + ipAddr;
        };
        public static final KeySelector<String> HOST_AND_METHOD = (ctx, req) -> HOST.get(ctx, req) + '#' + METHOD.get(ctx, req);

        public K get(ClientRequestContext var1, Request var2) throws Exception;
    }
}

